/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.test;

import fr.ifremer.adagio.core.service.ServiceLocator;
import fr.ifremer.adagio.core.test.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public abstract class AsbtractDaoTest {
    private static final Log log = LogFactory.getLog(AsbtractDaoTest.class);
    private static PlatformTransactionManager transactionManager;
    private TransactionStatus status;
    private boolean commitOnTearDown = true;

    @BeforeClass
    public static void beforeClass() {
        transactionManager = TestUtil.getBean("transactionManager", PlatformTransactionManager.class);
    }

    @Before
    public void setUp() throws Exception {
        this.status = transactionManager.getTransaction(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session and transaction initialized");
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.commitOnTearDown) {
            transactionManager.commit(this.status);
        } else {
            transactionManager.rollback(this.status);
        }
    }

    protected void setCommitOnTearDown(boolean commitOnTearDown) {
        this.commitOnTearDown = commitOnTearDown;
    }

    protected void commit() {
        transactionManager.commit(this.status);
        this.status = transactionManager.getTransaction(null);
    }

    protected <S> S getBean(String name, Class<S> serviceType) {
        return ServiceLocator.instance().getService(name, serviceType);
    }
}

