package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class SplitSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SplitSpeciesBatchUIModel, SplitSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_TEXT = "batchWeightField.text";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXTW8bRRieuLHz0aZtErW0tKC0JZCUaNLyWalQGpuGJLgpYl2omkMY707sacc7y85s68oq4ifwE+DOBYkbJ8SBM4dKgPgLCHHginhndr3rtddZh6o5rOJ53+f9nmdmvv0TFaWPzt0j7Tb2A1exFsVba3fu3Krfo7Z6n0rbZ54SPgr/xgqosIMOO/G6VOjCTlXDVyP4akW0POFStwd9tYqmpXrEqWxSqhR6IY2wpVy1YvHVthf4XatxUFlWv/77r8JXzpffFBBqexDdLKSykIdKMhmvogJzFJoDTw/IKiduA8LwmduAeGf0WoUTKbdJi36OvkATVVTyiA/GFDo/esrGhsG3PYVOS48zZXnUZlSWibKbNeF9RFzKFbq952O259MW9bEKlGI4YFg+hHiwLVwF5rHwqE8UEy62NZZKLENT2NjFVr/125ueZ7yXFCq2hKP93H0mfm5q44mzqQeEM4dAJRR6NdWTWBD5tPT3k+5iYqFU98V9CvDl4fHW9M8N8Fs2ugl4DjLZY40gzCIq8KlUHJEFUuemvVMxdgZypg3hP6qSuobN6VFoR/pbZlFrnogBx7sAmIO6KIu2QidSmO56GnbkpS2LwkTptC8pdDIFiSV9ruq62p9S1miqOJLnh+usM8qdfts12g4FadysJC2P0/2Np5RiI4tppWNKV9WyfcG5rr1Cz6WTiyXpyhcNTqEzwm/ge8Ay95XwQlAbb92Je3UxRhwmdk+D050yi8YB6NVhUiK9uP42cW3Ky0ai0HwKHK5qzUuxs2lJHtBE8FYk9dGZ1GABneGEzhK+GdtBRT+AZZjEnUEG/BhEIfed6uM+bdBI/z05/+SHP75f7xLeUfB9IlO1h6+BiDxfb2jFtOtjIdsFivHVm8S7uoOmJOVA9obMz2YEZkViCA78zWo41nC8QWQTTBQnfv/xp5Of/XIIFdbRNBfEWSdafxMK3/ShCoI7be+96yaiIw8n4XtcxwZbvGnGSKHCm5fakPjZjMRj7/Wpn/+Zt7673k1+DII5PVQ9KUDxLioxlzOXGr6PqDyT3w97kgaOSCg7i8SR53kZA3XNfMtZaRZ3m0BRCi10zof8NXAIYK1w/nE70DbWTXL6vw2034nhRXS3j+dSXfiO5tAXOy59uFBjilOnbNaW3IDzlQX9Xc50nEGheR7HFZrkmjjWNe3Pdfp58bECFSAfhV4eVog9TSm4C0xq98bw2qUhhpOiekKblBC8xrya8bp6EBOKeVllSZ8OI/TgSLi9qLOpaAvuPh1zDOMGVVYkqEQWl7IbMXC85Dkt9rWh/zxI2rC8f0F6gEkn3s7rRL+7uBlHd4njhILbLgOTK50mcR0O5zpUo2LGbWnZVCa0muhCafqb+doBoxjSz4ETdZQhpw6LjqriHuGSxgVd6ujozSUSrjQBXYqbXU7cLC3rbJ6+nhPU1UE43Sjy0jPogw3PfGfgvE+m5+L+cfcik3Sv5KU74PAZzc/rBw1jyAANXpvySnwIrse7NrwZAqWbN678IJmg5aETZPX4SY/Q/65pbj6jjsx8SHJwUJSJfb/hi8CFzEodfbw87hXDVNGueKZTERzeAeXqWuVD0JqUMHLpbTUTA/X7QqHFTpXJiDijRY6tze0Pqjd2rRvVG5Xa5q3t1NZY3I9vF869a07AzEKEt9G85PVFkl2+4t50aUu4zFYID+tFeFfF4bUTt2LAdCjY1K8vVArF8TwsjmQtmQU8fBbS/rOPyKEnQhoMewGasyuZHpU1I1JIdJ7+ZRm6kYMvzIpxvBZFoe9jmU1LXerzejcx0LuVnPT1C2BY58a1MO7bhREsJV1bye2a8Zzds1dGgZqOJdtiNtoWTJqnt+HH/n62nmU/LQgqt5s9L65RbrucPBKgjI6+4xBFFurMdSDWawOWx/R3OteiXv5Vf37LtnAZLPwHyrGSPkITAAA=";
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JTextField batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected JComboBox categoryComboBox;
    protected JLabel categoryLabel;
    protected Table configurationPanel;
    protected final SplitSpeciesBatchUIHandler handler = createHandler();
    protected SplitSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveButton;
    protected SplitSpeciesBatchUI splitSpeciesBatchTopPanel = this;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SplitSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SplitSpeciesBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI() {
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JTextField getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public SplitSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public SplitSpeciesBatchUIModel getModel() {
        return model;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSplitSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
        SwingUtil.setComponentHeight(actionPanel,50);
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new JTextField());
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setColumns(15);
        batchWeightField.setEditable(false);
        batchWeightField.setEnabled(false);
        batchWeightField.putClientProperty("help", "tutti.splitSpeciesBatch.field.batchWeightField.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.splitSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.splitSpeciesBatch.field.batchWeightField.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.batchWeightField.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.splitSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.splitSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.splitSpeciesBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.splitSpeciesBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.actions.SplitSpeciesBatchCancelAction.class);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.splitSpeciesBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.splitSpeciesBatch.field.categoryField.tip"));
        categoryLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.categoryField.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected SplitSpeciesBatchUIHandler createHandler() {
        return new SplitSpeciesBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SplitSpeciesBatchUIModel.class));
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.splitSpeciesBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.splitSpeciesBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.splitSpeciesBatch.field.sampleWeightField.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.splitSpeciesBatch.action.save"));
        saveButton.setToolTipText(t("tutti.splitSpeciesBatch.action.save.tip"));
        saveButton.putClientProperty("help", "tutti.splitSpeciesBatch.action.save.help");
        saveButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.actions.SplitSpeciesBatchSaveAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SplitSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        configurationPanel.setBorder(new TitledBorder(null, null));
        categoryLabel.setLabelFor(categoryComboBox);
        batchWeightLabel.setLabelFor(batchWeightField);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionBackground(null);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.splitSpeciesBatch.action.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.splitSpeciesBatch.action.save.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, splitSpeciesBatchTopPanel, "tutti.splitSpeciesBatch.help");
        registerHelpId(_broker, categoryLabel, "tutti.splitSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.splitSpeciesBatch.field.batchWeightField.help");
        registerHelpId(_broker, batchWeightField, "tutti.splitSpeciesBatch.field.batchWeightField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.splitSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.splitSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.splitSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.splitSpeciesBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("splitSpeciesBatchTopPanel", splitSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createCategoryLabel();
        createCategoryComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createBatchWeightLabel();
        createBatchWeightField();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        // inline creation of splitSpeciesBatchTopPanel
        setName("splitSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        splitSpeciesBatchTopPanel.putClientProperty("help", "tutti.splitSpeciesBatch.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchWeightField, getStringValue(model.getBatchWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}