/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import org.eclipse.birt.report.engine.api.script.instance.IDynamicTextInstance;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.instance.ReportItemInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;

public class DynamicTextInstance
extends ReportItemInstance
implements IDynamicTextInstance {
    protected IForeignContent fc = null;
    protected IDataContent dc = null;

    public DynamicTextInstance(IContent content, ExecutionContext context, RunningState runningState) {
        super(content, context, runningState);
        if (content instanceof IForeignContent) {
            this.fc = (IForeignContent)content;
        }
        if (content instanceof IDataContent) {
            this.dc = (IDataContent)content;
        }
    }

    @Override
    public String getText() {
        String type;
        if (this.fc != null && ("text/template".equals(type = this.fc.getRawType()) || "text/html".equals(type) || "text/plaintext".equals(type))) {
            return this.fc.getRawValue() == null ? null : this.fc.getRawValue().toString();
        }
        if (this.dc != null) {
            return this.dc.getText();
        }
        return null;
    }

    @Override
    public void setText(String value) {
        if (this.fc != null) {
            this.fc.setRawValue(value);
        }
        if (this.dc != null) {
            this.dc.setText(value);
        }
    }

    public Object getValue() {
        if (this.dc != null) {
            return this.dc.getValue();
        }
        return null;
    }
}

