/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SpringUtils {
    private static final Log log = LogFactory.getLog(SpringUtils.class);

    protected SpringUtils() {
    }

    public static List<Resource> getResourcesFromPaths(String[] paths, ApplicationContext appContext, boolean checkIfResourceExists) throws IOException, FileNotFoundException {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])paths));
        Preconditions.checkNotNull((Object)appContext);
        ArrayList resources = Lists.newArrayList();
        for (String path : paths) {
            try {
                Resource[] pathResources = appContext.getResources(path);
                resources.addAll(Arrays.asList(pathResources));
            }
            catch (IOException e) {
                throw new IOException(String.format("Error while getting files from path: %s", path), e);
            }
        }
        if (checkIfResourceExists) {
            for (Resource resource : resources) {
                if (resource.exists()) continue;
                throw new FileNotFoundException(String.format("File not found: %s", resource.getFilename()));
            }
        }
        return resources;
    }

    public static Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), SpringUtils.getClassLoader());
        }
        try {
            URL url = new URL(location);
            return new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            return SpringUtils.getResourceByPath(location);
        }
    }

    protected static Resource getResourceByPath(String path) {
        return new ClassPathContextResource(path, SpringUtils.getClassLoader());
    }

    protected static ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    protected static class ClassPathContextResource
    extends ClassPathResource
    implements ContextResource {
        public ClassPathContextResource(String path, ClassLoader classLoader) {
            super(path, classLoader);
        }

        public String getPathWithinContext() {
            return this.getPath();
        }

        public Resource createRelative(String relativePath) {
            String pathToUse = StringUtils.applyRelativePath((String)this.getPath(), (String)relativePath);
            return new ClassPathContextResource(pathToUse, this.getClassLoader());
        }
    }
}

