/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchModel;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CsvProducerForAccidentalCatch
extends CsvProducer<AccidentalCatchRow, AccidentalCatchModel> {
    public CsvProducerForAccidentalCatch(Path file, AccidentalCatchModel model) {
        super(file, model);
    }

    public List<AccidentalCatchRow> getDataToExport(GenericFormatExportOperationContext operationExportContext) {
        ArrayList<AccidentalCatchRow> rows = new ArrayList<AccidentalCatchRow>();
        List<AccidentalBatch> accidentalBatches = operationExportContext.getAccidentalBatches();
        if (CollectionUtils.isNotEmpty(accidentalBatches)) {
            for (AccidentalBatch accidentalBatch : accidentalBatches) {
                this.addAccidentalBatch(operationExportContext, rows, accidentalBatch);
            }
        }
        return rows;
    }

    protected void addAccidentalBatch(GenericFormatExportOperationContext operationExportContext, List<AccidentalCatchRow> rows, AccidentalBatch accidentalBatch) {
        CaracteristicMap caracteristics;
        this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, operationExportContext.getDeadOrAliveCaracteristic(), (Serializable)accidentalBatch.getDeadOrAlive());
        this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, operationExportContext.getGenderCaracteristic(), (Serializable)accidentalBatch.getGender());
        this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, operationExportContext.getWeightMeasuredCaracteristic(), accidentalBatch.getWeight());
        if (accidentalBatch.getLengthStepCaracteristic() != null) {
            this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, operationExportContext.getPmfmIdCaracteristic(), accidentalBatch.getLengthStepCaracteristic().getIdAsInt());
            this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, accidentalBatch.getLengthStepCaracteristic(), accidentalBatch.getSize());
        }
        if (MapUtils.isNotEmpty((Map)(caracteristics = accidentalBatch.getCaracteristics()))) {
            for (Map.Entry entry : caracteristics.entrySet()) {
                this.addCaracteristicRow(operationExportContext, rows, accidentalBatch, (Caracteristic)entry.getKey(), (Serializable)entry.getValue());
            }
        }
    }

    protected void addCaracteristicRow(GenericFormatExportOperationContext operationExportContext, List<AccidentalCatchRow> rows, AccidentalBatch accidentalBatch, Caracteristic caracteristic, Serializable caracteristicValue) {
        if (caracteristicValue != null) {
            AccidentalCatchRow row = new AccidentalCatchRow();
            row.setCruise(operationExportContext.getCruise());
            row.setFishingOperation(operationExportContext.getOperation());
            row.setComment(accidentalBatch.getComment());
            row.setSpecies(accidentalBatch.getSpecies());
            row.setBatchId(accidentalBatch.getIdAsInt());
            row.setCaracteristic(caracteristic);
            row.setCaracteristicValue(caracteristicValue);
            rows.add(row);
        }
    }
}

