/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForGearCaracteristic;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportGearCaracteristicAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportGearCaracteristicAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportGearCaracteristicAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.gearCaracteristics", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import gearCaracteristics.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.gearCaracteristics", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getGearCaracteristicFileResult();
        try (CsvConsumerForGearCaracteristic consumer = this.importContext.loadGearCaracteristics(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportCruiseContext cruiseContext = consumer.validateRow(row, this.importContext);
                if (cruiseContext == null) continue;
                consumer.prepareRowForPersist(cruiseContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close gearCaracteristic.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persistGearCaracteristics();
    }

    public void persistGearCaracteristics() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                ImportGearCaracteristicAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.gearCaracteristics", (Object[])new Object[]{cruiseContext.getCruiseLabel()}));
                if (cruiseContext.withGearCaracteristics()) {
                    Set<Gear> gears = cruiseContext.getGearsWithcaracteristics();
                    Cruise cruise = cruiseContext.getCruise();
                    for (Gear gear : gears) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + gear.getCaracteristics().size() + " gear caracteristics for gear: " + gear.getName() + " for cruise: " + cruiseContext.getCruiseLabel()));
                        }
                        ImportGearCaracteristicAction.this.persistenceHelper.saveGearCaracteristics(gear, cruise);
                    }
                }
            }
        });
    }
}

