/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class MoveListItemRecord
extends SimpleRecord {
    protected DesignElement element = null;
    protected StructureContext itemRef = null;
    protected int oldPosn = 0;
    protected int newPosn = 0;

    public MoveListItemRecord(DesignElement obj, StructureContext ref, int from, int to) {
        assert (obj != null);
        assert (ref != null);
        assert (obj.getPropertyDefn(ref.getElementProp().getName()) == ref.getElementProp());
        List theList = ref.getList(obj.getRoot());
        assert (from >= 0 && from < theList.size());
        assert (to >= 0 && to < theList.size());
        this.element = obj;
        this.itemRef = ref;
        this.oldPosn = from;
        this.newPosn = to;
        this.label = CommandLabelFactory.getCommandLabel("Message.MoveItem");
    }

    @Override
    protected void perform(boolean undo) {
        List list = this.itemRef.getList(this.element.getRoot());
        int from = undo ? this.newPosn : this.oldPosn;
        int to = undo ? this.oldPosn : this.newPosn;
        Object value = list.remove(from);
        list.add(to, value);
    }

    @Override
    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.itemRef.getPropDefn().getName());
    }
}

