/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.content.ListContainerExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFListLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    boolean needRepeat;
    boolean repeat = this.isRepeatHeader();
    int repeatCount = 0;

    public PDFListLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    @Override
    protected void initialize() throws BirtException {
        if (this.root == null && this.keepWithCache.isEmpty() && !this.isFirst) {
            this.repeatCount = 0;
            this.needRepeat = true;
        }
        super.initialize();
    }

    protected IListBandContent getHeader() {
        return ((IListContent)this.content).getHeader();
    }

    protected boolean isRepeatHeader() {
        return ((IListContent)this.content).isHeaderRepeat();
    }

    @Override
    protected boolean isRootEmpty() {
        return this.root == null || this.root.getChildrenCount() <= this.repeatCount;
    }

    @Override
    protected void createRoot() {
        if (this.root == null) {
            this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
        }
    }

    protected void repeatHeader() throws BirtException {
        if (this.isFirst) {
            return;
        }
        if (!this.needRepeat || !this.isRepeatHeader()) {
            return;
        }
        IListBandContent band = this.getHeader();
        if (band == null) {
            return;
        }
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(band);
        headerExecutor.execute();
        ContainerArea headerArea = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        headerArea.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        PDFRegionLM regionLM = new PDFRegionLM(this.context, headerArea, (IContent)band, (IReportItemExecutor)headerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
        if (headerArea.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            this.addArea(headerArea, false, this.pageBreakAvoid);
            ++this.repeatCount;
        }
        this.needRepeat = false;
    }

    @Override
    protected boolean traverseChildren() throws BirtException {
        this.repeatHeader();
        return super.traverseChildren();
    }

    @Override
    protected IReportItemExecutor createExecutor() {
        return new ListContainerExecutor(this.content, this.executor);
    }
}

