/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.pdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PdfGeneratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.service.export.ExportCatchContext;
import fr.ifremer.tutti.service.export.pdf.PdfExportBatchEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CatchesPdfExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CatchesPdfExportService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;
    protected PdfGeneratorService pdfGeneratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.pdfGeneratorService = this.getService(PdfGeneratorService.class);
    }

    public void generateCruisePDFFile(File targetFile, String cruiseId, Locale locale) {
        List<String> allFishingOperation = this.persistenceService.getAllFishingOperationIds(cruiseId);
        ArrayList operations = Lists.newArrayList();
        for (String operationId : allFishingOperation) {
            this.prepareOperation(operationId, operations);
        }
        this.generatePdf(targetFile, locale, operations);
    }

    public void generateFishingOperationPDFFile(File targetFile, String fishingOperationId, Locale locale) {
        ArrayList operations = Lists.newArrayList();
        this.prepareOperation(fishingOperationId, operations);
        this.generatePdf(targetFile, locale, operations);
    }

    protected void prepareOperation(String fishingOperationId, List<Map<String, Object>> operations) {
        ExportBatchEntry inertLivingNotItemizedCatch;
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
            }
            return;
        }
        ExportCatchContext exportContext = ExportCatchContext.newExportContext(this.persistenceService, this.weightComputingService, fishingOperationId, false);
        Map<String, Object> op = this.createOperation(exportContext.getFishingOperation());
        float totalWeight = exportContext.getCatchTotalWeight();
        op.put("totalWeight", Float.valueOf(totalWeight));
        op.put("totalSortedWeight", Float.valueOf(exportContext.getCatchTotalSortedWeight()));
        ArrayList catchList = Lists.newArrayList();
        if (exportContext.withSpeciesBatches()) {
            this.prepareOperationSpecies(exportContext, totalWeight, catchList);
        }
        if (exportContext.withBenthosBatches()) {
            this.prepareOperationBenthos(exportContext, totalWeight, catchList);
        }
        if ((inertLivingNotItemizedCatch = exportContext.getInertAndLivingNotItemizedCatch()).getSortedWeight() > 0.0f) {
            PdfExportBatchEntry pdfExportBatchEntry = new PdfExportBatchEntry(I18n.t((String)"tutti.service.operations.exportCatchesReport.specialRows.inertAndLivinngNotItemized.code", (Object[])new Object[0]), "", I18n.t((String)"tutti.service.operations.exportCatchesReport.specialRows.inertAndLivinngNotItemized.name", (Object[])new Object[0]), inertLivingNotItemizedCatch.getSortedWeight(), inertLivingNotItemizedCatch.getTotalWeight(), totalWeight);
            catchList.add(pdfExportBatchEntry);
        }
        if (log.isDebugEnabled()) {
            float computedTotalWeight = 0.0f;
            float computedPercentage = 0.0f;
            for (PdfExportBatchEntry entry : catchList) {
                computedTotalWeight += entry.getTotalWeight();
                computedPercentage += entry.getPercentage();
            }
            log.debug((Object)("TotalWeight: " + totalWeight));
            log.debug((Object)("ComputedTotalWeight: " + computedTotalWeight));
            log.debug((Object)("ComputedPercentage: " + computedPercentage));
        }
        op.put("catches", catchList);
        operations.add(op);
    }

    protected void prepareOperationSpecies(ExportCatchContext exportContext, float totalWeight, List<PdfExportBatchEntry> catchList) {
        List<ExportBatchEntry> speciesBatchEntries = exportContext.getSpeciesBatchEntry(false);
        TaxonCache taxonCache = TaxonCaches.createSpeciesCache((TuttiPersistence)this.persistenceService, (TuttiProtocol)this.context.getDataContext().getProtocol());
        for (ExportBatchEntry entry : speciesBatchEntries) {
            SpeciesAbleBatch batch = entry.getBatch();
            Species species = batch.getSpecies();
            taxonCache.load(species);
            String code = Speciess.getSurveyCodeOrRefTaxCode((Species)species);
            PdfExportBatchEntry pdfEntry = new PdfExportBatchEntry(code, species.getName(), species.getVernacularCode(), entry.getSortedWeight(), entry.getTotalWeight(), totalWeight);
            catchList.add(pdfEntry);
        }
    }

    protected void prepareOperationBenthos(ExportCatchContext exportContext, float totalWeight, List<PdfExportBatchEntry> catchList) {
        List<ExportBatchEntry> benthosBatchEntries = exportContext.getBenthosBatchEntry(false);
        float sortedWeight = 0.0f;
        float benthosTotalWeight = 0.0f;
        for (ExportBatchEntry entry : benthosBatchEntries) {
            sortedWeight += entry.getSortedWeight();
            benthosTotalWeight += entry.getTotalWeight();
        }
        PdfExportBatchEntry pdfEntry = new PdfExportBatchEntry(I18n.t((String)"tutti.service.operations.exportCatchesReport.specialRows.benthos.code", (Object[])new Object[0]), "", I18n.t((String)"tutti.service.operations.exportCatchesReport.specialRows.benthos.name", (Object[])new Object[0]), sortedWeight, benthosTotalWeight, totalWeight);
        catchList.add(pdfEntry);
    }

    protected void generatePdf(File targetFile, Locale locale, List<Map<String, Object>> operations) {
        HashMap data = Maps.newHashMap();
        data.put("operations", operations);
        this.pdfGeneratorService.generatePdf(targetFile, locale, "catchesReport.ftl", data);
    }

    protected Map<String, Object> createOperation(FishingOperation fishingOperation) {
        HashMap op = Maps.newHashMap();
        op.put("number", fishingOperation.getFishingOperationNumber());
        op.put("station", fishingOperation.getStationNumber());
        op.put("rigNumber", fishingOperation.getMultirigAggregation());
        op.put("startDate", fishingOperation.getGearShootingStartDate());
        op.put("endDate", fishingOperation.getGearShootingEndDate());
        return op;
    }
}

