/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.DataTypeConversionUtil;

public class DataSetParameterHandle
extends StructureHandle {
    public DataSetParameterHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public String getDataType() {
        String paramType = this.getStringProperty("dataType");
        return DataTypeConversionUtil.converToColumnDataType(paramType);
    }

    public void setDataType(String dataType) throws SemanticException {
        String paramType = DataTypeConversionUtil.converToParamType(dataType);
        this.setProperty("dataType", paramType);
    }

    public String getName() {
        return this.getStringProperty("name");
    }

    public void setName(String name) throws SemanticException {
        String oldName = this.getName();
        this.setProperty("name", name);
        if (oldName != null) {
            this.updateParamBindings(oldName, name);
        }
    }

    private void updateParamBindings(String oldParamName, String newParamName) {
        DataSetHandle.DataSetParametersPropertyHandle propHandle = (DataSetHandle.DataSetParametersPropertyHandle)this.getElementHandle().getPropertyHandle(this.getPropertyDefn().getName());
        propHandle.updateParamBindings(oldParamName, newParamName);
    }

    public Integer getPosition() {
        return (Integer)this.getProperty("position");
    }

    public void setPosition(Integer position) {
        this.setPropertySilently("position", position);
    }

    public boolean isOptional() {
        return (Boolean)this.getProperty("isOptional");
    }

    public void setIsOptional(boolean value) {
        this.setPropertySilently("isOptional", value);
    }

    public void setDefaultValue(String expr) {
        this.setPropertySilently("defaultValue", expr);
    }

    public String getDefaultValue() {
        return this.getStringProperty("defaultValue");
    }

    public boolean isInput() {
        return (Boolean)this.getProperty("isInput");
    }

    public void setIsInput(boolean isInput) {
        this.setPropertySilently("isInput", isInput);
    }

    public boolean isNullable() {
        return this.allowNull();
    }

    public void setIsNullable(boolean isNullable) {
        this.setAllowNull(isNullable);
    }

    public boolean allowNull() {
        return (Boolean)this.getProperty("allowNull");
    }

    public void setAllowNull(boolean allowNull) {
        this.setPropertySilently("allowNull", allowNull);
    }

    public boolean isOutput() {
        return (Boolean)this.getProperty("isOutput");
    }

    public void setIsOutput(boolean isOutput) {
        this.setPropertySilently("isOutput", isOutput);
    }

    @Override
    public MemberHandle getMember(String memberName) {
        StructPropertyDefn memberDefn = (StructPropertyDefn)this.getDefn().getMember(memberName);
        if (memberDefn == null) {
            return null;
        }
        if ("name".equalsIgnoreCase(memberName)) {
            return new NameMemberHandle(this, memberDefn);
        }
        return new MemberHandle(this, memberDefn);
    }

    public Integer getNativeDataType() {
        return (Integer)this.getProperty("nativeDataType");
    }

    public void setNativeDataType(Integer dataType) {
        this.setPropertySilently("nativeDataType", dataType);
    }

    public String getParameterDataType() {
        return this.getStringProperty("dataType");
    }

    public void setParameterDataType(String dataType) throws SemanticException {
        this.setProperty("dataType", dataType);
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setPropertySilently("displayName", displayName);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty("displayNameID");
    }

    public void setDisplayNameKey(String displayNameID) {
        this.setPropertySilently("displayNameID", displayNameID);
    }

    public String getHeading() {
        return this.getStringProperty("heading");
    }

    public void setHeading(String heading) {
        this.setPropertySilently("heading", heading);
    }

    public String getHeadingKey() {
        return this.getStringProperty("headingID");
    }

    public void setHeadingKey(String headingID) {
        this.setPropertySilently("headingID", headingID);
    }

    public String getHelpText() {
        return this.getStringProperty("helpText");
    }

    public void setHelpText(String helpText) {
        this.setPropertySilently("helpText", helpText);
    }

    public String getHelpTextKey() {
        return this.getStringProperty("helpTextID");
    }

    public void setHelpTextKey(String helpTextID) {
        this.setPropertySilently("helpTextID", helpTextID);
    }

    public String getDescription() {
        return this.getStringProperty("description");
    }

    public void setDescription(String description) {
        this.setPropertySilently("description", description);
    }

    public String getDescriptionKey() {
        return this.getStringProperty("descriptionID");
    }

    public void setDescriptoinKey(String descriptionID) {
        this.setPropertySilently("descriptionID", descriptionID);
    }

    static final class NameMemberHandle
    extends MemberHandle {
        public NameMemberHandle(StructureHandle structHandle, StructPropertyDefn member) {
            super(structHandle, member);
        }

        @Override
        public void setValue(Object value) throws SemanticException {
            String oldName = this.getStringValue();
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(this.changePropertyMessage());
            try {
                super.setValue(value);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            DataSetHandle.DataSetParametersPropertyHandle propHandle = (DataSetHandle.DataSetParametersPropertyHandle)this.getElementHandle().getPropertyHandle(this.getPropertyDefn().getName());
            propHandle.updateParamBindings(oldName, value.toString());
            as.commit();
        }

        private String changePropertyMessage() {
            return CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.getPropertyDefn().getDisplayName()});
        }
    }
}

