// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.qualification;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.ObjectType;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Représente la donnée qui a été qualifiée, par une plusieurs règles de qualification.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class QualifiedItem
    implements Serializable, Comparable<QualifiedItem>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 5542969326276950122L;

    // Generate 4 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Integer objectId;

    /**
     * Identifiant de l'élément ayant été qualifié.
     * @return this.objectId Integer
     */
    public Integer getObjectId()
    {
        return this.objectId;
    }

    /**
     * Identifiant de l'élément ayant été qualifié.
     * @param objectIdIn Integer
     */
    public void setObjectId(Integer objectIdIn)
    {
        this.objectId = objectIdIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 2 associations
    private Collection<AppliedQualificationRule> appliedQualificationRules = new HashSet<AppliedQualificationRule>();

    /**
     * Règle de qualification qui a été appliquée, sur une donnée.
     * @return this.appliedQualificationRules Collection<AppliedQualificationRule>
     */
    public Collection<AppliedQualificationRule> getAppliedQualificationRules()
    {
        return this.appliedQualificationRules;
    }

    /**
     * Règle de qualification qui a été appliquée, sur une donnée.
     * @param appliedQualificationRulesIn Collection<AppliedQualificationRule>
     */
    public void setAppliedQualificationRules(Collection<AppliedQualificationRule> appliedQualificationRulesIn)
    {
        this.appliedQualificationRules = appliedQualificationRulesIn;
    }

    /**
     * Règle de qualification qui a été appliquée, sur une donnée.
     * @param elementToAdd AppliedQualificationRule
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addAppliedQualificationRules(AppliedQualificationRule elementToAdd)
    {
        return this.appliedQualificationRules.add(elementToAdd);
    }

    /**
     * Règle de qualification qui a été appliquée, sur une donnée.
     * @param elementToRemove AppliedQualificationRule
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeAppliedQualificationRules(AppliedQualificationRule elementToRemove)
    {
        return this.appliedQualificationRules.remove(elementToRemove);
    }

    private ObjectType objectType;

    /**
     * Type d'entité qualifiée.
     * Généralement, on utilise le nom de la table principale de l'entité.
     * Exemple :
     * - FISHING_TRIP
     * - SALE
     * - PRODUCE
     * - etc.
     * @return this.objectType ObjectType
     */
    public ObjectType getObjectType()
    {
        return this.objectType;
    }

    /**
     * Type d'entité qualifiée.
     * Généralement, on utilise le nom de la table principale de l'entité.
     * Exemple :
     * - FISHING_TRIP
     * - SALE
     * - PRODUCE
     * - etc.
     * @param objectTypeIn ObjectType
     */
    public void setObjectType(ObjectType objectTypeIn)
    {
        this.objectType = objectTypeIn;
    }

    /**
     * Returns <code>true</code> if the argument is an QualifiedItem instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof QualifiedItem))
        {
            return false;
        }
        final QualifiedItem that = (QualifiedItem)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link QualifiedItem}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link QualifiedItem}.
         * @return new QualifiedItemImpl()
         */
        public static QualifiedItem newInstance()
        {
            return new QualifiedItemImpl();
        }

        /**
         * Constructs a new instance of {@link QualifiedItem}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param objectId Integer
         * @param objectType ObjectType
         * @return newInstance
         */
        public static QualifiedItem newInstance(Integer objectId, ObjectType objectType)
        {
            final QualifiedItem entity = new QualifiedItemImpl();
            entity.setObjectId(objectId);
            entity.setObjectType(objectType);
            return entity;
        }

        /**
         * Constructs a new instance of {@link QualifiedItem}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param objectId Integer
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param appliedQualificationRules Collection<AppliedQualificationRule>
         * @param objectType ObjectType
         * @return newInstance QualifiedItem
         */
        public static QualifiedItem newInstance(Integer objectId, Timestamp updateDate, Integer remoteId, Collection<AppliedQualificationRule> appliedQualificationRules, ObjectType objectType)
        {
            final QualifiedItem entity = new QualifiedItemImpl();
            entity.setObjectId(objectId);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setAppliedQualificationRules(appliedQualificationRules);
            entity.setObjectType(objectType);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(QualifiedItem o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getObjectId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getObjectId().compareTo(o.getObjectId()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// QualifiedItem.java merge-point
}