/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.mongodb.Mongo;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.mongodb.impl.MDbConnection;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class MongoDBDriver
implements IDriver {
    public static final String ODA_DATA_SOURCE_ID = "org.eclipse.birt.data.oda.mongodb";
    private static final String MONGO_PROP_PREFIX = "";
    public static final String IGNORE_URI_PROP = "".concat("ignoreURI");
    public static final String MONGO_URI_PROP = "".concat("mongoURI");
    public static final String SERVER_HOST_PROP = "".concat("serverHost");
    public static final String SERVER_PORT_PROP = "".concat("serverPort");
    public static final String DBNAME_PROP = "".concat("databaseName");
    public static final String USERNAME_PROP = "".concat("userName");
    public static final String PASSWORD_PROP = "".concat("password");
    public static final String SOCKET_KEEP_ALIVE_PROP = "".concat("socketKeepAlive");
    public static final String REQUEST_SESSION_PROP = "".concat("useRequestSession");
    private static final MongoDBDriver sm_factory = new MongoDBDriver();
    private static final MongoOptions sm_defaultClientOptions = MongoDBDriver.createDefaultClientOptions();
    private static ConcurrentMap<ServerNodeKey, Mongo> sm_mongoServerNodes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConcurrentMap<ServerNodeKey, Mongo> getMongoServerNodes() {
        if (sm_mongoServerNodes != null) return sm_mongoServerNodes;
        Class<MongoDBDriver> clazz = MongoDBDriver.class;
        synchronized (MongoDBDriver.class) {
            if (sm_mongoServerNodes != null) return sm_mongoServerNodes;
            sm_mongoServerNodes = new ConcurrentHashMap<ServerNodeKey, Mongo>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_mongoServerNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Class<MongoDBDriver> clazz = MongoDBDriver.class;
        synchronized (MongoDBDriver.class) {
            if (sm_mongoServerNodes == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            for (Mongo node : sm_mongoServerNodes.values()) {
                node.close();
            }
            sm_mongoServerNodes.clear();
            sm_mongoServerNodes = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Mongo getMongoNodeInstance(ServerNodeKey serverNodeKey) throws OdaException {
        Mongo mongoNode = (Mongo)MongoDBDriver.getMongoServerNodes().get(serverNodeKey);
        if (mongoNode != null) {
            return mongoNode;
        }
        mongoNode = MongoDBDriver.createMongoNode(serverNodeKey);
        Mongo existingNode = MongoDBDriver.getMongoServerNodes().putIfAbsent(serverNodeKey, mongoNode);
        if (existingNode == null) {
            return mongoNode;
        }
        mongoNode.close();
        return existingNode;
    }

    static Mongo getMongoNode(Properties connProperties) throws OdaException {
        ServerNodeKey nodeKey = MongoDBDriver.createServerNodeKey(connProperties);
        return MongoDBDriver.getMongoNodeInstance(nodeKey);
    }

    public IConnection getConnection(String dataSourceType) throws OdaException {
        return new MDbConnection();
    }

    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
    }

    public int getMaxConnections() throws OdaException {
        return 100;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    static ExtensionManifest getManifest() throws OdaException {
        return ManifestExplorer.getInstance().getExtensionManifest(ODA_DATA_SOURCE_ID);
    }

    static String getNativeDataTypeName(int nativeDataTypeCode) throws OdaException {
        DataTypeMapping typeMapping = MongoDBDriver.getManifest().getDataSetType(null).getDataTypeMapping(nativeDataTypeCode);
        if (typeMapping != null) {
            return typeMapping.getNativeType();
        }
        return Messages.mDbDriver_nonDefinedDataType;
    }

    private static Mongo createMongoNode(ServerNodeKey serverNodeKey) throws OdaException {
        List hosts = serverNodeKey.getServerHosts();
        String standaloneHost = hosts.size() == 1 ? (String)hosts.get(0) : null;
        Integer port = serverNodeKey.getServerPort();
        MongoOptions options = serverNodeKey.getOptions();
        if (options == null) {
            options = sm_defaultClientOptions;
        }
        try {
            if (standaloneHost != null) {
                ServerAddress serverAddr = port != null ? new ServerAddress(standaloneHost, port.intValue()) : new ServerAddress(standaloneHost);
                return new Mongo(serverAddr, options);
            }
            ArrayList<ServerAddress> serverSeeds = new ArrayList<ServerAddress>(hosts.size());
            for (String host : hosts) {
                serverSeeds.add(new ServerAddress(host));
            }
            return new Mongo(serverSeeds, options);
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    private static ServerNodeKey createServerNodeKey(Properties connProperties) {
        MongoDBDriver mongoDBDriver = sm_factory;
        mongoDBDriver.getClass();
        return mongoDBDriver.new ServerNodeKey(connProperties);
    }

    private static MongoOptions getMongoOptions(MongoURI mongoUri, Properties connProperties) {
        MongoOptions nodeOptions = mongoUri != null ? MongoDBDriver.getURIOptions(mongoUri) : null;
        return MongoDBDriver.addSupplementalOptions(nodeOptions, connProperties);
    }

    private static MongoOptions createDefaultClientOptions() {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        return new MongoOptions(optionsBuilder.build());
    }

    private static MongoOptions getURIOptions(MongoURI mongoUri) {
        MongoOptions uriOptions = mongoUri.getOptions();
        uriOptions.setConnectionsPerHost(sm_defaultClientOptions.getConnectionsPerHost());
        uriOptions.setWriteConcern(sm_defaultClientOptions.getWriteConcern());
        return uriOptions;
    }

    private static MongoOptions addSupplementalOptions(MongoOptions mongoOptions, Properties connProperties) {
        if (MongoDBDriver.hasKeepSocketAlive(connProperties).booleanValue()) {
            if (mongoOptions == null) {
                mongoOptions = MongoDBDriver.createDefaultClientOptions();
            }
            mongoOptions.setSocketKeepAlive(true);
        }
        return mongoOptions;
    }

    private static Boolean hasKeepSocketAlive(Properties connProperties) {
        String keepSocketAlivePropValue = MongoDBDriver.getStringPropValue(connProperties, SOCKET_KEEP_ALIVE_PROP);
        if (keepSocketAlivePropValue == null) {
            return Boolean.FALSE;
        }
        boolean keepSocketAlive = Boolean.valueOf(keepSocketAlivePropValue);
        if (!keepSocketAlive) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static String getDatabaseName(Properties connProps) {
        MongoURI mongoURI = MongoDBDriver.getMongoURI(connProps);
        if (mongoURI != null) {
            return mongoURI.getDatabase();
        }
        return MongoDBDriver.getStringPropValue(connProps, DBNAME_PROP);
    }

    static String getUserName(Properties connProps) {
        return MongoDBDriver.getStringPropValue(connProps, USERNAME_PROP);
    }

    static String getPassword(Properties connProps) {
        return MongoDBDriver.getStringPropValue(connProps, PASSWORD_PROP);
    }

    private static MongoURI getMongoURI(Properties connProps) {
        Boolean ignoreURI = MongoDBDriver.getBooleanPropValue(connProps, IGNORE_URI_PROP);
        if (ignoreURI != null && ignoreURI.booleanValue()) {
            return null;
        }
        String uri = MongoDBDriver.getStringPropValue(connProps, MONGO_URI_PROP);
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        try {
            return new MongoURI(uri);
        }
        catch (Exception ex) {
            MongoDBDriver.getLogger().log(Level.INFO, Messages.bind((String)"Invalid Mongo Database URI: {0}", (Object)uri), ex);
            return null;
        }
    }

    private static String formatMongoURI(Properties connProps) {
        String dbName;
        String serverHost = MongoDBDriver.getStringPropValue(connProps, SERVER_HOST_PROP);
        if (serverHost == null || serverHost.isEmpty()) {
            throw new IllegalArgumentException(Messages.mDbDriver_missingValueServerHost);
        }
        StringBuffer buf = new StringBuffer("mongodb://");
        String username = MongoDBDriver.getUserName(connProps);
        if (username != null && !username.isEmpty()) {
            String passwd = MongoDBDriver.getPassword(connProps);
            buf.append(username);
            buf.append(':');
            buf.append(passwd);
            buf.append('@');
        }
        buf.append(serverHost);
        Integer serverPort = MongoDBDriver.getIntegerPropValue(connProps, SERVER_PORT_PROP);
        if (serverPort != null) {
            buf.append(':');
            buf.append(serverPort);
        }
        if ((dbName = MongoDBDriver.getStringPropValue(connProps, DBNAME_PROP)) != null) {
            buf.append('/');
            buf.append(dbName);
        }
        return buf.toString();
    }

    static String getStringPropValue(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        return propValue != null ? propValue.trim() : null;
    }

    static Boolean getBooleanPropValue(Properties props, String propName) {
        String propValue = MongoDBDriver.getStringPropValue(props, propName);
        if (propValue == null || propValue.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(propValue);
    }

    static Integer getIntegerPropValue(Properties props, String propName) {
        String propValue = MongoDBDriver.getStringPropValue(props, propName);
        if (propValue == null || propValue.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(propValue);
        }
        catch (NumberFormatException ex) {
            MongoDBDriver.getLogger().log(Level.INFO, "MongoDBDriver#getIntegerPropValue ignoring exception: " + ex);
            return null;
        }
    }

    static Logger getLogger() {
        return DriverUtil.getLogger();
    }

    public static enum ReadPreferenceChoice {
        PRIMARY,
        PRIMARY_PREFERRED,
        SECONDARY,
        SECONDARY_PREFERRED,
        NEAREST;

        public static ReadPreferenceChoice DEFAULT;
        public static ReadPreference DEFAULT_PREFERENCE;

        static {
            DEFAULT = PRIMARY;
            DEFAULT_PREFERENCE = ReadPreference.primary();
        }

        public static ReadPreference getMongoReadPreference(String readPrefChoiceLiteral) {
            if (readPrefChoiceLiteral == null || readPrefChoiceLiteral.trim().isEmpty()) {
                return null;
            }
            try {
                return ReadPreference.valueOf((String)readPrefChoiceLiteral.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DEFAULT_PREFERENCE;
            }
        }

        public static ReadPreferenceChoice getReadPreferenceChoice(ReadPreference readPref) {
            if (readPref == null) {
                return PRIMARY;
            }
            String readPrefName = readPref.getName();
            if (readPrefName == ReadPreference.primary().getName()) {
                return PRIMARY;
            }
            if (readPrefName == ReadPreference.primaryPreferred().getName()) {
                return PRIMARY_PREFERRED;
            }
            if (readPrefName == ReadPreference.secondary().getName()) {
                return SECONDARY;
            }
            if (readPrefName == ReadPreference.secondaryPreferred().getName()) {
                return SECONDARY_PREFERRED;
            }
            if (readPrefName == ReadPreference.nearest().getName()) {
                return NEAREST;
            }
            return PRIMARY;
        }

        public String displayName() {
            if (this == PRIMARY) {
                return Messages.mDbDriver_readPrefPrimary;
            }
            if (this == PRIMARY_PREFERRED) {
                return Messages.mDbDriver_readPrefPrimaryPreferred;
            }
            if (this == SECONDARY) {
                return Messages.mDbDriver_readPrefSecondary;
            }
            if (this == SECONDARY_PREFERRED) {
                return Messages.mDbDriver_readPrefSecondaryPreferred;
            }
            if (this == NEAREST) {
                return Messages.mDbDriver_readPrefNearest;
            }
            return Messages.mDbDriver_readPrefPrimary;
        }
    }

    private class ServerNodeKey {
        private List<String> m_serverHosts;
        private Integer m_serverPort;
        private String m_userName;
        private MongoOptions m_options;

        ServerNodeKey(Properties connProperties) {
            MongoURI mongoUri = MongoDBDriver.getMongoURI(connProperties);
            MongoOptions nodeOptions = MongoDBDriver.getMongoOptions(mongoUri, connProperties);
            if (mongoUri != null) {
                this.init(mongoUri, nodeOptions);
                return;
            }
            this.init(connProperties, nodeOptions);
        }

        private void init(MongoURI mongoUri, MongoOptions options) {
            this.m_serverHosts = new ArrayList<String>(mongoUri.getHosts().size());
            for (String host : mongoUri.getHosts()) {
                this.m_serverHosts.add(host);
            }
            this.m_serverPort = ServerAddress.defaultPort();
            this.m_userName = mongoUri.getUsername();
            this.m_options = options;
            this.logInitializedValues("ServerNodeKey#init(MongoURI,MongoOptions)");
        }

        private void init(Properties connProperties, MongoOptions options) {
            this.m_serverHosts = new ArrayList<String>(1);
            this.m_serverHosts.add(MongoDBDriver.getStringPropValue(connProperties, SERVER_HOST_PROP));
            this.m_serverPort = MongoDBDriver.getIntegerPropValue(connProperties, SERVER_PORT_PROP);
            this.m_userName = MongoDBDriver.getUserName(connProperties);
            this.m_options = options;
            this.logInitializedValues("ServerNodeKey#init(Properties,MongoOptions)");
        }

        private void logInitializedValues(String methodName) {
            if (MongoDBDriver.getLogger().isLoggable(Level.FINEST)) {
                MongoDBDriver.getLogger().finest(Messages.bind((String)"{0}: hosts= {1}, port= {2}, user= {3}, options= {4}", (Object[])new Object[]{methodName, this.m_serverHosts, this.m_serverPort, this.m_userName, this.m_options}));
            }
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof ServerNodeKey)) {
                return false;
            }
            ServerNodeKey thatKey = (ServerNodeKey)obj;
            if (this.m_serverHosts == null && thatKey.m_serverHosts != null) {
                return false;
            }
            if (this.m_serverHosts != null && !this.m_serverHosts.equals(thatKey.m_serverHosts)) {
                return false;
            }
            if (this.m_serverPort == null && thatKey.m_serverPort != null) {
                return false;
            }
            if (this.m_serverPort != null && !this.m_serverPort.equals(thatKey.m_serverPort)) {
                return false;
            }
            if (this.m_options == null && thatKey.m_options != null) {
                return false;
            }
            if (this.m_options != null && !this.m_options.toString().equals(thatKey.m_options.toString())) {
                return false;
            }
            if (this.m_userName == null && thatKey.m_userName != null) {
                return false;
            }
            return this.m_userName == null || this.m_userName.equals(thatKey.m_userName);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.m_serverHosts != null) {
                hashCode = this.m_serverHosts.hashCode();
            }
            if (this.m_serverPort != null) {
                hashCode ^= this.m_serverPort.hashCode();
            }
            if (this.m_options != null) {
                hashCode ^= this.m_options.toString().hashCode();
            }
            if (this.m_userName != null) {
                hashCode ^= this.m_userName.hashCode();
            }
            return hashCode == 0 ? super.hashCode() : hashCode;
        }

        private List<String> getServerHosts() {
            if (this.m_serverHosts == null) {
                return Collections.emptyList();
            }
            return this.m_serverHosts;
        }

        private Integer getServerPort() {
            return this.m_serverPort;
        }

        private MongoOptions getOptions() {
            return this.m_options;
        }

        private String getUsername() {
            return this.m_userName;
        }
    }
}

