/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.api.aggregation.AggrFunctionWrapper;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.aggregation.IAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;

public class AggregationManager {
    private static final String ELEMENT_AGGREGATION_FACTORY = "AggregationFactory";
    private static final String ATTRIBUTE_AGGREGATION_CLASS = "aggregationClass";
    private static final String EXTENSION_POINT = "org.eclipse.birt.data.aggregation";
    private static final String ELEMENT_AGGREGATIONS = "Aggregations";
    private static final String ELEMENT_AGGREGATION = "Aggregation";
    private static final String ELEMENT_UIINFO = "UIInfo";
    private static final String ATTRIBUTE_PARAMETER_META_INFO = "parameterMetaInfo";
    private static final String ATTRIBUTE_TEXT_DATA = "textData";
    private static AggregationManager instance;
    public static Map aggrMap;
    private static Logger logger;
    private static String[] xTabAggrNames;
    public static final int AGGR_TABULAR = 0;
    public static final int AGGR_XTAB = 1;
    public static final int AGGR_MEASURE = 2;
    private static String[] measureAggrNames;
    private static List allAggrNames;

    static {
        logger = Logger.getLogger(AggregationManager.class.getName());
        xTabAggrNames = new String[]{"SUM", "AVE", "MAX", "MIN", "FIRST", "LAST", "COUNT", "COUNTDISTINCT", "MEDIAN", "MODE", "STDDEV", "VARIANCE", "RANK", "RUNNINGSUM"};
        measureAggrNames = new String[]{"SUM", "MAX", "MIN", "FIRST", "LAST", "COUNT"};
        allAggrNames = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AggregationManager getInstance() throws DataException {
        if (instance != null) return instance;
        Class<AggregationManager> clazz = AggregationManager.class;
        synchronized (AggregationManager.class) {
            if (instance != null) return instance;
            aggrMap = new HashMap();
            instance = new AggregationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AggregationManager() throws DataException {
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals(ELEMENT_AGGREGATIONS)) {
                        IConfigurationElement[] subElems = configElems[i].getChildren(ELEMENT_AGGREGATION_FACTORY);
                        this.populateFactoryAggregations(subElems);
                        subElems = configElems[i].getChildren(ELEMENT_AGGREGATION);
                        this.populateDeprecatedAggregations(subElems);
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    private void populateFactoryAggregations(IConfigurationElement[] subElems) throws DataException {
        if (subElems == null) {
            return;
        }
        int j = 0;
        while (j < subElems.length) {
            try {
                IAggregationFactory factory = (IAggregationFactory)subElems[j].createExecutableExtension("class");
                List functions = factory.getAggregations();
                for (IAggrFunction aggrFunc : functions) {
                    String name = aggrFunc.getName().toUpperCase();
                    if (aggrMap.put(name, aggrFunc) != null) {
                        throw new DataException("date.engine.DuplicateAggregationName", name);
                    }
                    allAggrNames.add(name);
                }
            }
            catch (FrameworkException frameworkException) {}
            ++j;
        }
    }

    private void populateDeprecatedAggregations(IConfigurationElement[] subElems) throws DataException {
        if (subElems == null) {
            return;
        }
        int j = 0;
        while (j < subElems.length) {
            try {
                IAggregation aggrFunc = (IAggregation)subElems[j].createExecutableExtension(ATTRIBUTE_AGGREGATION_CLASS);
                String name = aggrFunc.getName().toUpperCase();
                AggrFunctionWrapper aggrWrapper = new AggrFunctionWrapper(aggrFunc);
                this.populateExtendedAggrInfo(name, aggrFunc, subElems[j], aggrWrapper);
                if (aggrMap.put(name, aggrWrapper) != null) {
                    throw new DataException("date.engine.DuplicateAggregationName", name);
                }
                allAggrNames.add(name);
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, AggrFunctionWrapper.class.getName(), "populateDeprecatedAggregations", "Exception in aggregation extension loading.", e);
            }
            ++j;
        }
    }

    private void populateExtendedAggrInfo(String name, IAggregation aggrFunc, IConfigurationElement elem, AggrFunctionWrapper aggrWrapper) throws DataException {
        IConfigurationElement[] uiInfo = elem.getChildren(ELEMENT_UIINFO);
        assert (uiInfo != null && uiInfo.length == 1);
        String paramInfo = uiInfo[0].getAttribute(ATTRIBUTE_PARAMETER_META_INFO);
        String textInfo = uiInfo[0].getAttribute(ATTRIBUTE_TEXT_DATA);
        aggrWrapper.setDisplayName(textInfo);
        ArrayList<AggrFunctionWrapper.ParameterDefn> paramList = new ArrayList<AggrFunctionWrapper.ParameterDefn>();
        String[] paramInfos = paramInfo.split(",");
        boolean[] paramFlags = aggrFunc.getParameterDefn();
        if (paramInfos != null && paramInfos.length > 0 && paramFlags != null) {
            if (paramInfos.length != paramFlags.length) {
                throw new DataException("data.engine.InconsistentAggregationArgumentDefinition");
            }
            int k = 0;
            while (k < paramInfos.length) {
                String s = paramInfos[k].trim();
                int index = s.indexOf(32);
                String paramName = null;
                paramName = index > 0 ? s.substring(index + 1).trim() : paramInfos[k];
                AggrFunctionWrapper.ParameterDefn paramDefn = new AggrFunctionWrapper.ParameterDefn(paramName, paramName, !paramFlags[k], true);
                paramList.add(paramDefn);
                ++k;
            }
        }
        IParameterDefn[] params = new IParameterDefn[paramList.size()];
        paramList.toArray(params);
        aggrWrapper.setParameterDefn(params);
    }

    private void populateDataFiledParameterDefn(List paramList) {
        String expression = DataResourceHandle.getInstance().getMessage("data.aggregation.expression.displayName");
        AggrFunctionWrapper.ParameterDefn expressionDefn = new AggrFunctionWrapper.ParameterDefn("Expression", expression, false, true);
        paramList.add(expressionDefn);
    }

    public static void destroyInstance() {
        instance = null;
        aggrMap = null;
    }

    public IAggrFunction getAggregation(String name) {
        return name != null ? (IAggrFunction)aggrMap.get(name.toUpperCase()) : null;
    }

    public List getAggregations(int type) {
        switch (type) {
            case 0: {
                return this.getResult(allAggrNames.toArray());
            }
            case 1: {
                return this.getResult(xTabAggrNames);
            }
            case 2: {
                return this.getResult(measureAggrNames);
            }
        }
        return new ArrayList();
    }

    private List getResult(Object[] names) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < names.length) {
            Object aggrFunc = aggrMap.get(names[i]);
            if (aggrFunc != null) {
                list.add(aggrFunc);
            }
            ++i;
        }
        return list;
    }

    public List getAggregations() {
        return this.getResult(allAggrNames.toArray());
    }
}

