/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroSchemaValidationException;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchroMetadataUtils {
    private static final Log log = LogFactory.getLog(SynchroMetadataUtils.class);
    public static final List<String> ORACLE_EXCLUDE_TABLE_PATTERNS = Lists.newArrayList((Object[])new String[]{"BIN%", "MDR%"});

    protected SynchroMetadataUtils() {
    }

    public static Predicate<String> newAllTablesOraclePredicate() {
        return SynchroMetadataUtils.newTablesOraclePredicate(null, null);
    }

    public static Predicate<String> newTablesOraclePredicate(Set<String> excludes, Set<String> includes) {
        HashSet excludesPatterns = Sets.newHashSet(ORACLE_EXCLUDE_TABLE_PATTERNS);
        if (CollectionUtils.isNotEmpty(excludes)) {
            excludesPatterns.addAll(excludes);
        }
        return SynchroMetadataUtils.newTablePredicate(excludesPatterns, includes);
    }

    public static Predicate<String> newTablePredicate(final Set<String> excludes, final Set<String> includes) {
        if (CollectionUtils.isEmpty(excludes) && CollectionUtils.isEmpty(includes)) {
            return null;
        }
        return new Predicate<String>(){

            public boolean apply(String tableName) {
                if (CollectionUtils.isNotEmpty((Collection)excludes)) {
                    for (String excludePattern : excludes) {
                        if (!tableName.matches(excludePattern.replaceAll("%", ".*"))) continue;
                        return false;
                    }
                }
                if (CollectionUtils.isEmpty((Collection)includes)) {
                    return true;
                }
                for (String includePattern : includes) {
                    if (!tableName.matches(includePattern.replaceAll("%", ".*"))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<SynchroColumnMetadata> newExcludeColumnPredicate(final Set<String> columnExcludes) {
        if (columnExcludes == null || columnExcludes.isEmpty()) {
            return null;
        }
        return new Predicate<SynchroColumnMetadata>(){

            public boolean apply(SynchroColumnMetadata input) {
                return !columnExcludes.contains(input.getTableName().toLowerCase() + "." + input.getName().toLowerCase()) && !columnExcludes.contains("%." + input.getName().toLowerCase());
            }
        };
    }

    public static Set<String> checkSchemas(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema, boolean allowMissingOptionalColumn, boolean allowAdditionalMandatoryColumnInSourceSchema) throws SynchroSchemaValidationException, SynchroTechnicalException {
        if (!allowMissingOptionalColumn) {
            SynchroMetadataUtils.checkSchemasStrict(sourceSchema, targetSchema);
            return null;
        }
        return SynchroMetadataUtils.checkSchemasAllowMissingOptionalColumn(sourceSchema, targetSchema, allowAdditionalMandatoryColumnInSourceSchema);
    }

    protected static Set<String> checkSchemasAllowMissingOptionalColumn(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema, boolean allowAdditionalMandatoryColumnInSourceSchema) throws SynchroSchemaValidationException {
        Set<String> sourceSchemaTableNames;
        HashSet missingColumns = Sets.newHashSet();
        Set<String> targetSchemaTableNames = targetSchema.getLoadedTableNames();
        if (!targetSchemaTableNames.equals(sourceSchemaTableNames = sourceSchema.getLoadedTableNames())) {
            HashSet missingTargetTables = Sets.newHashSet();
            for (String targetTableName : targetSchemaTableNames) {
                if (sourceSchemaTableNames.contains(targetTableName)) continue;
                missingTargetTables.add(targetTableName);
            }
            HashSet missingSourceTables = Sets.newHashSet();
            for (String sourceTableName : sourceSchemaTableNames) {
                if (targetSchemaTableNames.contains(sourceTableName)) continue;
                missingSourceTables.add(sourceTableName);
            }
            throw new SynchroSchemaValidationException(String.format("Incompatible schemas.\nMissing tables in source database: %s\nMissing tables in target database: %s", missingTargetTables, missingSourceTables));
        }
        for (String tableName : targetSchemaTableNames) {
            Set<String> sourceColumnNames;
            SynchroTableMetadata targetTable = targetSchema.getLoadedTable(tableName);
            SynchroTableMetadata sourceTable = sourceSchema.getLoadedTable(tableName);
            HashSet targetColumnNames = Sets.newHashSet(targetTable.getColumnNames());
            if (!targetColumnNames.equals(sourceColumnNames = sourceTable.getColumnNames())) {
                TreeSet missingMandatoryColumns = Sets.newTreeSet();
                HashSet missingSourceColumnNames = Sets.newHashSet(sourceColumnNames);
                for (String targetColumnName : targetTable.getColumnNames()) {
                    if (!sourceColumnNames.contains(targetColumnName)) {
                        SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(targetColumnName);
                        if (targetColumn.isNullable()) {
                            log.debug((Object)String.format("Optional column not found in source database: %s.%s. Will be ignore.", tableName, targetColumnName));
                            missingColumns.add(tableName + "." + targetColumnName);
                            targetColumnNames.remove(targetColumnName);
                        } else {
                            log.warn((Object)String.format("Column not found in source database: %s.%s", tableName, targetColumnName));
                            missingMandatoryColumns.add(targetColumnName);
                        }
                    }
                    missingSourceColumnNames.remove(targetColumnName);
                }
                for (String sourceColumnName : missingSourceColumnNames) {
                    SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(sourceColumnName);
                    if (allowAdditionalMandatoryColumnInSourceSchema || sourceColumn.isNullable()) {
                        log.debug((Object)String.format("Optional column not found in target database: %s.%s. Will be ignore.", tableName, sourceColumnName));
                        missingColumns.add(tableName + "." + sourceColumnName);
                        continue;
                    }
                    log.warn((Object)String.format("Column not found in target database: %s.%s. Will be ignore.", tableName, sourceColumnName));
                    missingMandatoryColumns.add(sourceColumnName);
                }
                if (CollectionUtils.isNotEmpty((Collection)missingMandatoryColumns)) {
                    throw new SynchroSchemaValidationException(String.format("Incompatible schema of table: %s. Missing mandatory columns: %s", tableName, missingMandatoryColumns));
                }
            }
            for (String columnName : targetColumnNames) {
                SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(columnName);
                SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(columnName);
                SynchroMetadataUtils.checkType(tableName, targetColumn, sourceColumn);
            }
        }
        return missingColumns;
    }

    protected static void checkSchemasStrict(SynchroDatabaseMetadata sourceSchema, SynchroDatabaseMetadata targetSchema) throws SynchroSchemaValidationException {
        Set<String> sourceSchemaTableNames = sourceSchema.getLoadedTableNames();
        Set<String> targetSchemaTableNames = targetSchema.getLoadedTableNames();
        if (!targetSchemaTableNames.equals(sourceSchemaTableNames)) {
            throw new SynchroSchemaValidationException("Incompatible schemas: missing tables");
        }
        for (String tableName : sourceSchemaTableNames) {
            SynchroTableMetadata sourceTable = sourceSchema.getTable(tableName);
            SynchroTableMetadata targetTable = targetSchema.getTable(tableName);
            Set<String> sourceColumnNames = sourceTable.getColumnNames();
            Set<String> targetColumnNames = targetTable.getColumnNames();
            if (!targetColumnNames.equals(sourceColumnNames)) {
                throw new SynchroSchemaValidationException("Incompatible schema of table: " + tableName);
            }
            for (String columnName : targetColumnNames) {
                SynchroColumnMetadata sourceColumn = sourceTable.getColumnMetadata(columnName);
                SynchroColumnMetadata targetColumn = targetTable.getColumnMetadata(columnName);
                SynchroMetadataUtils.checkType(tableName, targetColumn, sourceColumn);
            }
        }
    }

    public static void checkType(String tableName, SynchroColumnMetadata internalColumn, SynchroColumnMetadata externalColumn) {
        if (SynchroMetadataUtils.isNumericType(internalColumn) && SynchroMetadataUtils.isNumericType(externalColumn)) {
            int internalColumnSize = internalColumn.getColumnSize();
            int externalColumnSize = externalColumn.getColumnSize();
            if (internalColumnSize > 0 && externalColumnSize > 0 && internalColumnSize < externalColumnSize) {
                throw new SynchroTechnicalException(String.format("Incompatible type for column [%s.%s]. Incompatible precision between %s and %s", tableName, internalColumn.getName(), internalColumn.getSqlTypeName(), externalColumn.getSqlTypeName()));
            }
            int internalDecimalDigits = internalColumn.getDecimalDigits();
            int externalDecimalDigits = externalColumn.getDecimalDigits();
            if (internalDecimalDigits > 0 && externalDecimalDigits > 0 && internalDecimalDigits < externalDecimalDigits) {
                throw new SynchroTechnicalException(String.format("Incompatible column type of table / column: %s / %s", tableName, internalColumn.getName()));
            }
        } else if (!(SynchroMetadataUtils.isDateType(internalColumn) && SynchroMetadataUtils.isDateType(externalColumn) || SynchroMetadataUtils.isBooleanType(internalColumn) && SynchroMetadataUtils.isBooleanType(externalColumn))) {
            int externalColumnTypeCode;
            String internalColumnTypeName = internalColumn.getTypeName();
            String externalColumnTypeName = externalColumn.getTypeName();
            int internalColumnTypeCode = internalColumn.getTypeCode();
            if (internalColumnTypeCode != (externalColumnTypeCode = externalColumn.getTypeCode()) && !internalColumnTypeName.equals(externalColumnTypeName)) {
                throw new SynchroTechnicalException(String.format("Incompatible column type of table / column: %s / %s", tableName, internalColumn.getName()));
            }
        }
    }

    public static boolean isNumericType(SynchroColumnMetadata column) {
        int typeCode = column.getTypeCode();
        if (typeCode == -5 || typeCode == 4 || typeCode == 2 || typeCode == 3 || typeCode == 6 || typeCode == 7 || typeCode == 5 || typeCode == -6 || typeCode == 8) {
            return true;
        }
        String columnTypeName = column.getTypeName();
        return columnTypeName.equals("NUMBER") || columnTypeName.equals("INTEGER") || columnTypeName.equals("SMALLINT");
    }

    public static boolean isDateType(SynchroColumnMetadata column) {
        String columnTypeName = column.getTypeName();
        return columnTypeName.equals("TIMESTAMP") || columnTypeName.equals("DATE");
    }

    public static boolean isBooleanType(SynchroColumnMetadata column) {
        int typeCode = column.getTypeCode();
        int columnSize = column.getColumnSize();
        if ((typeCode == 1 || typeCode == 12) && columnSize == 1) {
            return true;
        }
        String columnTypeName = column.getTypeName();
        return columnTypeName.equals("BOOLEAN") || columnTypeName.equals("NUMBER") && columnSize == 1 || columnTypeName.equals("INTEGER") && columnSize == 1 || columnTypeName.equals("SMALLINT") && columnSize == 1 || columnTypeName.equals("BIT") && columnSize == 1;
    }

    public static String ensureMaximumNameLength(String name, Integer nameMaxLength) {
        if (StringUtils.isNotBlank((CharSequence)name) && nameMaxLength != null) {
            int max = nameMaxLength;
            if (name.length() > max) {
                name = name.substring(0, max);
            }
        }
        return name;
    }
}

