// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel;

import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.util.Date;

/**
 * Période d'armement, ou de mise en service, du navire.
 * La mise en service est rattaché à un lieu terrestre de mise en service. Cela peut etre le pays
 * d'armement ou le quartier d'armement.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselCommissioningPeriod
    implements Serializable, Comparable<VesselCommissioningPeriod>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4526710880810578705L;

    private VesselCommissioningPeriodPK vesselCommissioningPeriodPk;

    /**
     * Get the composite primary key identifier class
     * @return vesselCommissioningPeriodPk
     */
    public VesselCommissioningPeriodPK getVesselCommissioningPeriodPk()
    {
        return this.vesselCommissioningPeriodPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param vesselCommissioningPeriodPkIn
     */
    public void setVesselCommissioningPeriodPk(VesselCommissioningPeriodPK vesselCommissioningPeriodPkIn) {
        this.vesselCommissioningPeriodPk = vesselCommissioningPeriodPkIn;
    }

    // Generate 2 attributes
    /**
     * 
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.getVesselCommissioningPeriodPk().getStartDate();
    }

    /**
     * 
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.getVesselCommissioningPeriodPk().setStartDate(startDateIn);
    }

    private Date endDate;

    /**
     * 
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * 
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    // Generate 2 associations
    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Location commissioningLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.commissioningLocation Location
     */
    public Location getCommissioningLocation()
    {
        return this.commissioningLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param commissioningLocationIn Location
     */
    public void setCommissioningLocation(Location commissioningLocationIn)
    {
        this.commissioningLocation = commissioningLocationIn;
    }

    /**
     * Returns <code>true</code> if the argument is an VesselCommissioningPeriod instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof VesselCommissioningPeriod))
        {
            return false;
        }
        final VesselCommissioningPeriod that = (VesselCommissioningPeriod)object;
        if (this.vesselCommissioningPeriodPk == null || that.vesselCommissioningPeriodPk == null || !this.vesselCommissioningPeriodPk.equals(that.vesselCommissioningPeriodPk))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.vesselCommissioningPeriodPk == null ? 0 : this.vesselCommissioningPeriodPk.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link VesselCommissioningPeriod}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselCommissioningPeriod}.
         * @return new VesselCommissioningPeriodImpl()
         */
        public static VesselCommissioningPeriod newInstance()
        {
            return new VesselCommissioningPeriodImpl();
        }

        /**
         * Constructs a new instance of {@link VesselCommissioningPeriod}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param vessel Vessel
         * @param commissioningLocation Location
         * @return newInstance
         */
        public static VesselCommissioningPeriod newInstance(Vessel vessel, Location commissioningLocation)
        {
            final VesselCommissioningPeriod entity = new VesselCommissioningPeriodImpl();
            entity.setVessel(vessel);
            entity.setCommissioningLocation(commissioningLocation);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselCommissioningPeriod}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param endDate Date
         * @param vessel Vessel
         * @param commissioningLocation Location
         * @return newInstance VesselCommissioningPeriod
         */
        public static VesselCommissioningPeriod newInstance(Date endDate, Vessel vessel, Location commissioningLocation)
        {
            final VesselCommissioningPeriod entity = new VesselCommissioningPeriodImpl();
            entity.setEndDate(endDate);
            entity.setVessel(vessel);
            entity.setCommissioningLocation(commissioningLocation);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselCommissioningPeriod o)
    {
        int cmp = 0;
        if (this.getVesselCommissioningPeriodPk() != null)
        {
            cmp = this.getVesselCommissioningPeriodPk().compareTo(o.getVesselCommissioningPeriodPk());
        }
        else
        {
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselCommissioningPeriod.java merge-point
}