// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.physicalGear;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselPhysicalFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Enquete sur les engins physiques d'un navire et leurs caractéristiques.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class PhysicalGearSurvey
    implements Serializable, Comparable<PhysicalGearSurvey>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 8808013955808440115L;

    // Generate 12 attributes
    private Integer id;

    /**
     * Identifiant interne de l'enquete d'engin physique. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne de l'enquete d'engin physique. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private Integer year;

    /**
     * Année sur laquelle porte l'enquete
     * @return this.year Integer
     */
    public Integer getYear()
    {
        return this.year;
    }

    /**
     * Année sur laquelle porte l'enquete
     * @param yearIn Integer
     */
    public void setYear(Integer yearIn)
    {
        this.year = yearIn;
    }

    private Boolean directSurveyInvestigation;

    /**
     * Objectif d'enquete directe ?
     * Issu de la feuille de route (pointeur ‘ENQUETE DIRECTE’ de la feuille de route). Indique si
     * le navire était prévu en enquête directe ou non pour l'année de référence : Oui ou Non. Cette
     * information n'est jamais saisie par l'utilisateur, elle est issue d'un flux venant
     * d'Harmonie.
     * @return this.directSurveyInvestigation Boolean
     */
    public Boolean isDirectSurveyInvestigation()
    {
        return this.directSurveyInvestigation;
    }

    /**
     * Objectif d'enquete directe ?
     * Issu de la feuille de route (pointeur ‘ENQUETE DIRECTE’ de la feuille de route). Indique si
     * le navire était prévu en enquête directe ou non pour l'année de référence : Oui ou Non. Cette
     * information n'est jamais saisie par l'utilisateur, elle est issue d'un flux venant
     * d'Harmonie.
     * @param directSurveyInvestigationIn Boolean
     */
    public void setDirectSurveyInvestigation(Boolean directSurveyInvestigationIn)
    {
        this.directSurveyInvestigation = directSurveyInvestigationIn;
    }

    private String comments;

    /**
     * Commentaire sur l'enquete
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur l'enquete
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création de l'enquete dans le système central.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création de l'enquete dans le système central.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * Date de la dernière mise à jour dans le système central
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de la dernière mise à jour dans le système central
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 8 associations
    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<VesselPhysicalFeatures> vesselPhysicalFeatures = new HashSet<VesselPhysicalFeatures>();

    /**
     * Caractéristiques physique d'un navire (navire de peche ou océanographique, ou autres).
     * @return this.vesselPhysicalFeatures Collection<VesselPhysicalFeatures>
     */
    public Collection<VesselPhysicalFeatures> getVesselPhysicalFeatures()
    {
        return this.vesselPhysicalFeatures;
    }

    /**
     * Caractéristiques physique d'un navire (navire de peche ou océanographique, ou autres).
     * @param vesselPhysicalFeaturesIn Collection<VesselPhysicalFeatures>
     */
    public void setVesselPhysicalFeatures(Collection<VesselPhysicalFeatures> vesselPhysicalFeaturesIn)
    {
        this.vesselPhysicalFeatures = vesselPhysicalFeaturesIn;
    }

    /**
     * Caractéristiques physique d'un navire (navire de peche ou océanographique, ou autres).
     * @param elementToAdd VesselPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPhysicalFeatures(VesselPhysicalFeatures elementToAdd)
    {
        return this.vesselPhysicalFeatures.add(elementToAdd);
    }

    /**
     * Caractéristiques physique d'un navire (navire de peche ou océanographique, ou autres).
     * @param elementToRemove VesselPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPhysicalFeatures(VesselPhysicalFeatures elementToRemove)
    {
        return this.vesselPhysicalFeatures.remove(elementToRemove);
    }

    private Vessel vessel;

    /**
     * Navire concerné par l'enquete
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire concerné par l'enquete
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Collection<GearPhysicalFeatures> gearPhysicalFeatures = new HashSet<GearPhysicalFeatures>();

    /**
     * Liste des engin physiques dont les caractéristiques ont été receuillies au cours de
     * l'enquete.
     * @return this.gearPhysicalFeatures Collection<GearPhysicalFeatures>
     */
    public Collection<GearPhysicalFeatures> getGearPhysicalFeatures()
    {
        return this.gearPhysicalFeatures;
    }

    /**
     * Liste des engin physiques dont les caractéristiques ont été receuillies au cours de
     * l'enquete.
     * @param gearPhysicalFeaturesIn Collection<GearPhysicalFeatures>
     */
    public void setGearPhysicalFeatures(Collection<GearPhysicalFeatures> gearPhysicalFeaturesIn)
    {
        this.gearPhysicalFeatures = gearPhysicalFeaturesIn;
    }

    /**
     * Liste des engin physiques dont les caractéristiques ont été receuillies au cours de
     * l'enquete.
     * @param elementToAdd GearPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearPhysicalFeatures(GearPhysicalFeatures elementToAdd)
    {
        return this.gearPhysicalFeatures.add(elementToAdd);
    }

    /**
     * Liste des engin physiques dont les caractéristiques ont été receuillies au cours de
     * l'enquete.
     * @param elementToRemove GearPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearPhysicalFeatures(GearPhysicalFeatures elementToRemove)
    {
        return this.gearPhysicalFeatures.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an PhysicalGearSurvey instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof PhysicalGearSurvey))
        {
            return false;
        }
        final PhysicalGearSurvey that = (PhysicalGearSurvey)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link PhysicalGearSurvey}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link PhysicalGearSurvey}.
         * @return new PhysicalGearSurveyImpl()
         */
        public static PhysicalGearSurvey newInstance()
        {
            return new PhysicalGearSurveyImpl();
        }

        /**
         * Constructs a new instance of {@link PhysicalGearSurvey}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param year Integer
         * @param directSurveyInvestigation Boolean
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance
         */
        public static PhysicalGearSurvey newInstance(String synchronizationStatus, Integer year, Boolean directSurveyInvestigation, Date creationDate, Department recorderDepartment, Program program, QualityFlag qualityFlag, Vessel vessel)
        {
            final PhysicalGearSurvey entity = new PhysicalGearSurveyImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setYear(year);
            entity.setDirectSurveyInvestigation(directSurveyInvestigation);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link PhysicalGearSurvey}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param year Integer
         * @param directSurveyInvestigation Boolean
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vesselPhysicalFeatures Collection<VesselPhysicalFeatures>
         * @param vessel Vessel
         * @param gearPhysicalFeatures Collection<GearPhysicalFeatures>
         * @return newInstance PhysicalGearSurvey
         */
        public static PhysicalGearSurvey newInstance(String synchronizationStatus, Integer year, Boolean directSurveyInvestigation, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Collection<SurveyMeasurement> surveyMeasurements, Department recorderDepartment, Person recorderPerson, Program program, QualityFlag qualityFlag, Collection<VesselPhysicalFeatures> vesselPhysicalFeatures, Vessel vessel, Collection<GearPhysicalFeatures> gearPhysicalFeatures)
        {
            final PhysicalGearSurvey entity = new PhysicalGearSurveyImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setYear(year);
            entity.setDirectSurveyInvestigation(directSurveyInvestigation);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVesselPhysicalFeatures(vesselPhysicalFeatures);
            entity.setVessel(vessel);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(PhysicalGearSurvey o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getYear() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getYear().compareTo(o.getYear()));
            }
            if (this.isDirectSurveyInvestigation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isDirectSurveyInvestigation().compareTo(o.isDirectSurveyInvestigation()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// PhysicalGearSurvey.java merge-point
}