/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.UnknownHandlerConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.xwork2.XWork2ScopeValidator;

public class XWork2ValidatorUtil {
    private static final Log log = LogFactory.getLog(XWork2ValidatorUtil.class);
    private static ValueStack sharedValueStack;

    public static ValueStack getSharedValueStack() {
        if (sharedValueStack == null) {
            sharedValueStack = XWork2ValidatorUtil.createValuestack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("init shared value stack " + sharedValueStack));
            }
        }
        return sharedValueStack;
    }

    public static void setSharedValueStack(ValueStack sharedValueStack) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("set shared value stack " + sharedValueStack));
        }
        XWork2ValidatorUtil.sharedValueStack = sharedValueStack;
    }

    public static ValueStack createValuestack() {
        ValueStack result;
        ActionContext context = ActionContext.getContext();
        if (context == null) {
            ConfigurationManager confManager = new ConfigurationManager();
            Configuration conf = confManager.getConfiguration();
            Container container = conf.getContainer();
            ValueStackFactory stackFactory = (ValueStackFactory)container.getInstance(ValueStackFactory.class);
            result = stackFactory.createValueStack();
        } else {
            result = context.getValueStack();
            if (result == null) {
                ValueStackFactory stackFactory = (ValueStackFactory)context.getInstance(ValueStackFactory.class);
                result = stackFactory.createValueStack();
            }
        }
        return result;
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields) {
        return XWork2ValidatorUtil.newXWorkScopeValidator(beanClass, contextName, fields, XWork2ValidatorUtil.getSharedValueStack());
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields, ValueStack vs) {
        return new XWork2ScopeValidator<O>(beanClass, contextName, fields, vs);
    }

    public static String getContextForScope(String context, NuitonValidatorScope scope) {
        return (context == null ? "" : context + "-") + scope.name().toLowerCase();
    }

    protected static ActionValidatorManager newValidationManager(ValueStack vs) {
        ActionContext context;
        if (vs == null) {
            vs = XWork2ValidatorUtil.createValuestack();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create a standalone value stack " + vs));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("use given value stack " + vs));
        }
        if ((context = ActionContext.getContext()) == null) {
            context = new ActionContext(vs.getContext());
            ActionContext.setContext((ActionContext)context);
        }
        Container container = context.getContainer();
        if (context.getActionInvocation() == null) {
            Configuration configuration = (Configuration)container.getInstance(Configuration.class);
            UnknownHandlerConfig unknownHandlerStack = new UnknownHandlerConfig("nuiton");
            List unknownHandlerStackList = configuration.getUnknownHandlerStack();
            if (unknownHandlerStackList == null) {
                unknownHandlerStackList = Lists.newArrayList();
                configuration.setUnknownHandlerStack(unknownHandlerStackList);
            }
            unknownHandlerStackList.add(0, unknownHandlerStack);
            HashMap extraContext = Maps.newHashMap();
            extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", vs);
            DefaultActionInvocation invocation = new DefaultActionInvocation((Map)extraContext, false);
            invocation.setObjectFactory((ObjectFactory)container.getInstance(ObjectFactory.class));
            invocation.setContainer(container);
            ActionProxyFactory actionProxyFactory = (ActionProxyFactory)context.getInstance(ActionProxyFactory.class);
            ActionProxy actionProxy = actionProxyFactory.createActionProxy((ActionInvocation)invocation, "java.lang", "java.lang.Object", "nuiton-validation", false, false);
            invocation.init(actionProxy);
            context.setActionInvocation((ActionInvocation)invocation);
        }
        ActionValidatorManager validatorManager = (ActionValidatorManager)container.getInstance(ActionValidatorManager.class, "no-annotations");
        return validatorManager;
    }

    public static <O> Map<NuitonValidatorScope, String[]> detectFields(Class<O> type, String context, NuitonValidatorScope[] scopeUniverse) {
        Set availableFields = BeanUtil.getReadableProperties(type);
        ActionValidatorManager validatorManager = XWork2ValidatorUtil.newValidationManager(XWork2ValidatorUtil.getSharedValueStack());
        TreeMap<NuitonValidatorScope, String[]> fields = new TreeMap<NuitonValidatorScope, String[]>();
        for (NuitonValidatorScope scope : scopeUniverse) {
            Set<String> fieldNames = XWork2ValidatorUtil.detectFieldsForScope(validatorManager, type, scope, context, availableFields, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected validator fields for scope " + (Object)((Object)scope) + ":" + context + " : " + fieldNames));
            }
            if (fieldNames.isEmpty()) continue;
            fields.put(scope, fieldNames.toArray(new String[fieldNames.size()]));
        }
        return fields;
    }

    protected static Set<String> detectFieldsForScope(ActionValidatorManager validator, Class<?> type, NuitonValidatorScope scope, String context, Set<String> availableFields, boolean includeDefaultContext) {
        String scopeContext = XWork2ValidatorUtil.getContextForScope(context, scope);
        HashSet<String> fields = new HashSet<String>();
        int skip = 0;
        if (scopeContext != null && !includeDefaultContext) {
            for (Validator v : validator.getValidators(type, null)) {
                if (!(v instanceof FieldValidator)) continue;
                ++skip;
            }
        }
        for (Validator v : validator.getValidators(type, scopeContext)) {
            String fName;
            if (!(v instanceof FieldValidator)) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            FieldValidator fieldValidator = (FieldValidator)v;
            if (log.isDebugEnabled()) {
                log.debug((Object)("context " + context + " - field " + fieldValidator.getFieldName()));
            }
            if (availableFields.contains(fName = fieldValidator.getFieldName())) {
                fields.add(fName);
                continue;
            }
            if (BeanUtil.isNestedReadableProperty(type, (String)fName)) {
                fields.add(fName);
                continue;
            }
            String message = "Field " + fName + " in scope [" + scopeContext + "] is not a readable property of " + type.getName();
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new IllegalStateException(message);
        }
        return fields;
    }

    public static class NuitonDefaultUnknownHandler
    implements UnknownHandler {
        protected Configuration configuration;
        protected ObjectFactory objectFactory;

        @Inject
        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        @Inject
        public void setObjectFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public ActionConfig handleUnknownAction(String namespace, String actionName) throws XWorkException {
            return new ActionConfig.Builder(namespace, actionName, Object.class.getName()).build();
        }

        public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) throws XWorkException {
            return null;
        }

        public Object handleUnknownActionMethod(Object action, String methodName) throws NoSuchMethodException {
            return null;
        }
    }
}

