/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.conversion.ConversionAnnotationProcessor;
import com.opensymphony.xwork2.conversion.ConversionFileProcessor;
import com.opensymphony.xwork2.conversion.ConversionPropertiesProcessor;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.TypeConverterHolder;
import com.opensymphony.xwork2.conversion.annotations.Conversion;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import com.opensymphony.xwork2.conversion.impl.XWorkBasicConverter;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWorkConverter
extends DefaultTypeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(XWorkConverter.class);
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    public static final String LAST_BEAN_CLASS_ACCESSED = "last.bean.accessed";
    public static final String LAST_BEAN_PROPERTY_ACCESSED = "last.property.accessed";
    public static final String MESSAGE_INDEX_PATTERN = "\\[\\d+\\]\\.";
    public static final String MESSAGE_INDEX_BRACKET_PATTERN = "[\\[\\]\\.]";
    public static final String PERIOD = ".";
    public static final Pattern messageIndexPattern = Pattern.compile("\\[\\d+\\]\\.");
    private TypeConverter defaultTypeConverter;
    private FileManager fileManager;
    private boolean reloadingConfigs;
    private ConversionFileProcessor fileProcessor;
    private ConversionAnnotationProcessor annotationProcessor;
    private TypeConverterHolder converterHolder;

    protected XWorkConverter() {
    }

    @Inject
    public void setDefaultTypeConverter(XWorkBasicConverter conv) {
        this.defaultTypeConverter = conv;
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Inject(value="reloadXmlConfiguration", required=false)
    public void setReloadingConfigs(String reloadingConfigs) {
        this.reloadingConfigs = Boolean.parseBoolean(reloadingConfigs);
    }

    @Inject
    public void setConversionPropertiesProcessor(ConversionPropertiesProcessor propertiesProcessor) {
        propertiesProcessor.process("xwork-default-conversion.properties");
        propertiesProcessor.process("xwork-conversion.properties");
    }

    @Inject
    public void setConversionFileProcessor(ConversionFileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }

    @Inject
    public void setConversionAnnotationProcessor(ConversionAnnotationProcessor annotationProcessor) {
        this.annotationProcessor = annotationProcessor;
    }

    @Inject
    public void setTypeConverterHolder(TypeConverterHolder converterHolder) {
        this.converterHolder = converterHolder;
    }

    public static String getConversionErrorMessage(String propertyName, ValueStack stack) {
        String defaultMessage = LocalizedTextUtil.findDefaultText("xwork.default.invalid.fieldvalue", ActionContext.getContext().getLocale(), new Object[]{propertyName});
        List<String> indexValues = XWorkConverter.getIndexValues(propertyName);
        propertyName = XWorkConverter.removeAllIndexesInProperytName(propertyName);
        String getTextExpression = "getText('invalid.fieldvalue." + propertyName + "','" + defaultMessage + "')";
        String message = (String)stack.findValue(getTextExpression);
        message = message == null ? defaultMessage : MessageFormat.format(message, indexValues.toArray());
        return message;
    }

    private static String removeAllIndexesInProperytName(String propertyName) {
        return propertyName.replaceAll(MESSAGE_INDEX_PATTERN, PERIOD);
    }

    private static List<String> getIndexValues(String propertyName) {
        Matcher matcher = messageIndexPattern.matcher(propertyName);
        ArrayList<String> indexes = new ArrayList<String>();
        while (matcher.find()) {
            Integer index = new Integer(matcher.group().replaceAll(MESSAGE_INDEX_BRACKET_PATTERN, "")) + 1;
            indexes.add(Integer.toString(index));
        }
        return indexes;
    }

    public String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        return className.replace('.', '/') + "-conversion.properties";
    }

    @Override
    public Object convertValue(Map<String, Object> map, Object o, Class aClass) {
        return this.convertValue(map, null, null, null, o, aClass);
    }

    @Override
    public Object convertValue(Map<String, Object> context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (value != null && toClass == value.getClass()) {
            return value;
        }
        if (target != null) {
            Class clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            tc = (TypeConverter)this.getConverter(clazz, property);
            if (LOG.isDebugEnabled()) {
                LOG.debug("field-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc), new String[0]);
            }
        }
        if (tc == null && context != null) {
            Object lastPropertyPath = context.get("current.property.path");
            Class clazz = (Class)context.get(LAST_BEAN_CLASS_ACCESSED);
            if (lastPropertyPath != null && clazz != null) {
                String path = lastPropertyPath + PERIOD + property;
                tc = (TypeConverter)this.getConverter(clazz, path);
            }
        }
        if (tc == null) {
            tc = toClass.equals(String.class) && value != null && !value.getClass().equals(String.class) && !value.getClass().equals(String[].class) ? this.lookup(value.getClass()) : this.lookup(toClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("global-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc), new String[0]);
            }
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable to convert value using type converter [#0]", e, tc.getClass().getName());
                }
                this.handleConversionException(context, property, value, target);
                return TypeConverter.NO_CONVERSION_POSSIBLE;
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("falling back to default type converter [" + this.defaultTypeConverter + "]", new String[0]);
                }
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable to convert value using type converter [#0]", e, this.defaultTypeConverter.getClass().getName());
                }
                this.handleConversionException(context, property, value, target);
                return TypeConverter.NO_CONVERSION_POSSIBLE;
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("falling back to Ognl's default type conversion", new String[0]);
            }
            return super.convertValue(value, toClass);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to convert value using type converter [#0]", e, super.getClass().getName());
            }
            this.handleConversionException(context, property, value, target);
            return TypeConverter.NO_CONVERSION_POSSIBLE;
        }
    }

    public TypeConverter lookup(String className) {
        if (this.converterHolder.containsUnknownMapping(className) && !this.converterHolder.containsDefaultMapping(className)) {
            return null;
        }
        TypeConverter result = this.converterHolder.getDefaultMapping(className);
        if (result == null) {
            Class<?> clazz;
            block6: {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Cannot load class #0", cnfe, className);
                }
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        if (clazz.isPrimitive()) {
            return this.defaultTypeConverter;
        }
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving convert for class [#0] and property [#1]", clazz, property);
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (property != null && !this.converterHolder.containsNoMapping(clazz)) {
                try {
                    Map<String, Object> mapping = this.converterHolder.getMapping(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    Object converter = mapping.get(property);
                    if (LOG.isDebugEnabled() && converter == null) {
                        LOG.debug("Converter is null for property [#0]. Mapping size [#1]:", property, mapping.size());
                        for (String next : mapping.keySet()) {
                            LOG.debug(next + ":" + mapping.get(next), new String[0]);
                        }
                    }
                    return converter;
                }
                catch (Throwable t) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Got exception trying to resolve convert for class [#0] and property [#1]", t, clazz, property);
                    }
                    this.converterHolder.addNoMapping(clazz);
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map<String, Object> context, String property, Object value, Object object) {
        if (context != null && Boolean.TRUE.equals(context.get(REPORT_CONVERSION_ERRORS))) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork2.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork2.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    public synchronized void registerConverter(String className, TypeConverter converter) {
        this.converterHolder.addDefaultMapping(className, converter);
    }

    public synchronized void registerConverterNotFound(String className) {
        this.converterHolder.addUnknownMapping(className);
    }

    private Object[] getClassProperty(Map<String, Object> context) {
        Object[] objectArray;
        Object lastClass = context.get(LAST_BEAN_CLASS_ACCESSED);
        Object lastProperty = context.get(LAST_BEAN_PROPERTY_ACCESSED);
        if (lastClass != null && lastProperty != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = lastClass;
            objectArray = objectArray2;
            objectArray2[1] = lastProperty;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    protected void addConverterMapping(Map<String, Object> mapping, Class clazz) {
        String converterFilename = this.buildConverterFilename(clazz);
        this.fileProcessor.process(mapping, clazz, converterFilename);
        Annotation[] annotations = clazz.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Conversion)) continue;
            Conversion conversion = (Conversion)annotation;
            for (TypeConversion tc : conversion.conversions()) {
                if (mapping.containsKey(tc.key())) break;
                if (LOG.isDebugEnabled()) {
                    if (StringUtils.isEmpty((CharSequence)tc.key())) {
                        LOG.debug("WARNING! key of @TypeConversion [#0] applied to [#1] is empty!", tc.converter(), clazz.getName());
                    } else {
                        LOG.debug("TypeConversion [#0] with key: [#1]", tc.converter(), tc.key());
                    }
                }
                this.annotationProcessor.process(mapping, tc, tc.key());
            }
        }
        block2: for (Method method : clazz.getMethods()) {
            for (Annotation annotation : annotations = method.getAnnotations()) {
                TypeConversion tc;
                if (!(annotation instanceof TypeConversion)) continue;
                tc = (TypeConversion)annotation;
                if (mapping.containsKey(tc.key())) continue block2;
                String key = tc.key();
                if (StringUtils.isEmpty((CharSequence)key)) {
                    key = AnnotationUtils.resolvePropertyName(method);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Retrieved key [#0] from method name [#1]", key, method.getName());
                    }
                }
                this.annotationProcessor.process(mapping, tc, key);
            }
        }
    }

    protected Map<String, Object> buildConverterMapping(Class clazz) throws Exception {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Class curClazz = clazz;
        while (!curClazz.equals(Object.class)) {
            Class<?>[] interfaces;
            this.addConverterMapping(mapping, curClazz);
            for (Class<?> anInterface : interfaces = curClazz.getInterfaces()) {
                this.addConverterMapping(mapping, anInterface);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.converterHolder.addMapping(clazz, mapping);
        } else {
            this.converterHolder.addNoMapping(clazz);
        }
        return mapping;
    }

    private Map<String, Object> conditionalReload(Class clazz, Map<String, Object> oldValues) throws Exception {
        URL fileUrl;
        Map<String, Object> mapping = oldValues;
        if (this.reloadingConfigs && this.fileManager.fileNeedsReloading(fileUrl = ClassLoaderUtil.getResource(this.buildConverterFilename(clazz), clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = this.converterHolder.getDefaultMapping(clazz.getName())) == null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                if (!this.converterHolder.containsDefaultMapping(anInterface.getName())) continue;
                result = this.converterHolder.getDefaultMapping(anInterface.getName());
                break;
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }
}

