/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.test;

import fr.ifremer.adagio.core.service.ServiceLocator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public abstract class BaseDaoTest {
    private static final Log log = LogFactory.getLog(BaseDaoTest.class);
    private static PlatformTransactionManager transactionManager;
    private TransactionStatus status;
    private boolean commitOnTearDown = true;

    @BeforeClass
    public static void beforeClass() {
        transactionManager = BaseDaoTest.getBean("transactionManager", PlatformTransactionManager.class);
    }

    @Before
    public void setUp() throws Exception {
        this.status = transactionManager.getTransaction(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session and transaction initialized");
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.commitOnTearDown) {
            transactionManager.commit(this.status);
        } else {
            transactionManager.rollback(this.status);
        }
    }

    protected void setCommitOnTearDown(boolean commitOnTearDown) {
        this.commitOnTearDown = commitOnTearDown;
    }

    protected static <S> S getBean(String name, Class<S> serviceType) {
        return ServiceLocator.instance().getService(name, serviceType);
    }

    protected Query createStatelessQuery(String hqlQuery) {
        SessionFactory sessionFactory = BaseDaoTest.getBean("sessionFactory", SessionFactory.class);
        StatelessSession session = sessionFactory.openStatelessSession();
        Query query = session.createQuery(hqlQuery);
        return query;
    }

    protected long countEntities(Class entityClass) {
        return this.countEntities(entityClass, null, "");
    }

    protected long countEntities(Class entityClass, String alias, String whereClause) {
        if (StringUtils.isNotBlank((CharSequence)whereClause)) {
            whereClause = " " + alias + " where " + whereClause;
        }
        Query query = this.createStatelessQuery("select count(*) from " + entityClass.getName() + whereClause);
        return (Long)query.uniqueResult();
    }

    protected void commit() {
        transactionManager.commit(this.status);
        this.status = transactionManager.getTransaction(null);
    }
}

