/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.config;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.config.AdagioEnumerationHelper;
import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public class AdagioConfigurationModelEnumProvider
implements ApplicationConfigProvider {
    public String getName() {
        return "adagio-db-enumerations";
    }

    public String getDescription(Locale locale) {
        return I18n.l((Locale)locale, (String)"adagio-db-enumerations.config", (Object[])new Object[0]);
    }

    public ConfigOptionDef[] getOptions() {
        ArrayList options = Lists.newArrayList();
        List<AdagioEnumerationDef<?>> enumDefs = AdagioEnumerationHelper.getAllModelEnumerations();
        for (AdagioEnumerationDef<?> enumDef : enumDefs) {
            AdagioEnumerationOption option = new AdagioEnumerationOption(enumDef);
            options.add(option);
        }
        return options.toArray(new ConfigOptionDef[options.size()]);
    }

    public ConfigActionDef[] getActions() {
        return new ConfigActionDef[0];
    }

    static class AdagioEnumerationOption
    implements ConfigOptionDef {
        private static final long serialVersionUID = -5720186783497571417L;
        private AdagioEnumerationDef<?> delegatedEnum;

        public AdagioEnumerationOption(AdagioEnumerationDef<?> delegatedEnum) {
            this.delegatedEnum = delegatedEnum;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public String getDefaultValue() {
            return this.delegatedEnum.getValueAsString();
        }

        public String getDescription() {
            return this.delegatedEnum.getDescription();
        }

        public String getKey() {
            return this.delegatedEnum.getKey();
        }

        public Class getType() {
            return this.delegatedEnum.getType();
        }

        public void setDefaultValue(String defaultValue) {
        }

        public void setTransient(boolean isTransient) {
        }

        public void setFinal(boolean isFinal) {
        }
    }
}

