/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.measure.file.MeasurementFile;
import fr.ifremer.adagio.core.dao.data.measure.file.MeasurementFileDao;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.stereotype.Service;

@Service(value="attachmentPersistenceService")
public class AttachmentPersistenceServiceImpl
extends AbstractPersistenceService
implements AttachmentPersistenceService {
    private static final Log log = LogFactory.getLog(AttachmentPersistenceServiceImpl.class);
    protected static final String ATTACHMENT_PATH_FORMAT = "%1$s/OBJ%2$s/%1$s-OBJ%2$s-%3$s.%4$s";
    @Resource(name="measurementFileDao")
    protected MeasurementFileDao measurementFileDao;
    protected File dbAttachmentDirectory;

    @Override
    public void init() {
        super.init();
        this.dbAttachmentDirectory = this.config.getDbAttachmentDirectory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Db Attachment storage: " + this.dbAttachmentDirectory));
        }
    }

    @Override
    public List<Attachment> getAllAttachments(ObjectTypeCode objectType, Integer objectId) {
        Iterator<Object[]> list = this.queryList("allAttachment", "objectId", IntegerType.INSTANCE, objectId, "objectTypeCode", StringType.INSTANCE, objectType.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Attachment target = Attachments.newAttachment();
            this.loadAttachment(source, target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public File getAttachmentFile(String attachmentId) {
        Object[] source = this.queryUnique("attachment", "attachmentId", IntegerType.INSTANCE, Integer.valueOf(attachmentId));
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve Attachment with id=" + attachmentId);
        }
        Attachment target = Attachments.newAttachment();
        this.loadAttachment(source, target);
        File result = this.getFile(target);
        return result;
    }

    @Override
    public Attachment createAttachment(Attachment attachment, File file) {
        Preconditions.checkNotNull((Object)attachment);
        Preconditions.checkNotNull((Object)attachment.getObjectType());
        Preconditions.checkNotNull((Object)attachment.getObjectId());
        Preconditions.checkArgument((attachment.getId() == null ? 1 : 0) != 0, (Object)"Attachment 'id' must be null to call createAttachment().");
        Preconditions.checkNotNull((Object)file);
        MeasurementFile measurementFile = MeasurementFile.Factory.newInstance();
        measurementFile.setPmfm(null);
        measurementFile.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        measurementFile.setObjectType((ObjectType)this.load(ObjectTypeImpl.class, (Serializable)((Object)attachment.getObjectType().getValue())));
        measurementFile.setObjectId(attachment.getObjectId());
        measurementFile.setPath("FAKE-" + System.nanoTime());
        this.attachmentToEntity(attachment, measurementFile);
        this.measurementFileDao.create(measurementFile);
        attachment.setId(String.valueOf(measurementFile.getId()));
        String filePath = String.format(ATTACHMENT_PATH_FORMAT, measurementFile.getObjectType().getCode(), measurementFile.getObjectId(), measurementFile.getId(), ApplicationIOUtil.getExtension((String)file.getName()));
        attachment.setPath(filePath);
        measurementFile.setPath(filePath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created attachment: " + attachment.getId() + ", path: " + filePath));
        }
        this.measurementFileDao.update(measurementFile);
        File targetFile = this.getFile(attachment);
        ApplicationIOUtil.copyFile((File)file, (File)targetFile, (String)I18n.t((String)"tutti.persistence.attachment.copyFile.error", (Object[])new Object[]{file, targetFile}));
        return attachment;
    }

    @Override
    public Attachment saveAttachment(Attachment attachment) {
        Preconditions.checkNotNull((Object)attachment);
        Preconditions.checkNotNull((Object)attachment.getObjectType());
        Preconditions.checkNotNull((Object)attachment.getObjectId());
        Preconditions.checkNotNull((Object)attachment.getId(), (Object)"Attachment 'id' must not be null or empty to be saved.");
        MeasurementFile measurementFile = this.measurementFileDao.load(Integer.valueOf(attachment.getId()));
        if (measurementFile == null) {
            throw new DataRetrievalFailureException("Could not retrieve Attachment with id=" + attachment.getId());
        }
        String oldObjectTypeCode = measurementFile.getObjectType().getCode();
        if (ObjectUtils.notEqual((Object)attachment.getObjectType().getValue(), (Object)oldObjectTypeCode)) {
            throw new InvalidDataAccessResourceUsageException("Can't change objectType, was before " + oldObjectTypeCode);
        }
        Integer oldObjectId = measurementFile.getObjectId();
        if (ObjectUtils.notEqual((Object)attachment.getObjectId(), (Object)oldObjectId)) {
            throw new InvalidDataAccessResourceUsageException("Can't change objectId, was before " + oldObjectId);
        }
        this.attachmentToEntity(attachment, measurementFile);
        this.measurementFileDao.update(measurementFile);
        return attachment;
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        Integer id = Integer.valueOf(attachmentId);
        Object[] source = this.queryUnique("attachment", "attachmentId", IntegerType.INSTANCE, id);
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve Attachment with id=" + attachmentId);
        }
        Attachment target = Attachments.newAttachment();
        this.loadAttachment(source, target);
        this.delete(target);
        this.getCurrentSession().flush();
    }

    @Override
    public void deleteAllAttachment(ObjectTypeCode objectType, Integer ... objectIds) {
        for (Integer objectId : objectIds) {
            List<Attachment> attachments = this.getAllAttachments(objectType, objectId);
            for (Attachment attachment : attachments) {
                this.delete(attachment);
            }
        }
    }

    protected void loadAttachment(Object[] source, Attachment target) {
        target.setObjectType(ObjectTypeCode.valueOf((String)((String)source[0])));
        target.setObjectId((Integer)source[1]);
        target.setId(String.valueOf(source[2]));
        target.setPath((String)source[3]);
        target.setName((String)source[4]);
        target.setComment((String)source[5]);
    }

    protected void attachmentToEntity(Attachment attachment, MeasurementFile measurementFile) {
        measurementFile.setName(attachment.getName());
        measurementFile.setComments(attachment.getComment());
    }

    protected File getFile(Attachment attachment) {
        File result = new File(this.dbAttachmentDirectory, attachment.getPath());
        return result;
    }

    protected void delete(Attachment target) {
        this.measurementFileDao.remove(target.getIdAsInt());
        File file = this.getFile(target);
        ApplicationIOUtil.deleteFile((File)file, (String)I18n.t((String)"tutti.persistence.attachment.deleteFile.error", (Object[])new Object[]{file}));
    }
}

