/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TechnicalPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.GearPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.LocationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ObjectTypePersistenceService;
import fr.ifremer.tutti.persistence.service.referential.PersonPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.VesselPersistenceService;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

public class TuttiPersistenceImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    protected CaracteristicPersistenceService caracteristicService;
    @Resource(name="gearPersistenceService")
    protected GearPersistenceService gearService;
    @Resource(name="locationPersistenceService")
    protected LocationPersistenceService locationService;
    @Resource(name="objectTypePersistenceService")
    protected ObjectTypePersistenceService objectTypeService;
    @Resource(name="personPersistenceService")
    protected PersonPersistenceService personService;
    @Resource(name="speciesPersistenceService")
    protected SpeciesPersistenceService speciesService;
    @Resource(name="vesselPersistenceService")
    protected VesselPersistenceService vesselService;
    @Resource(name="programPersistenceService")
    protected ProgramPersistenceService programService;
    @Resource(name="cruisePersistenceService")
    protected CruisePersistenceService cruiseService;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationService;
    @Resource(name="batchPersistenceService")
    protected CatchBatchPersistenceService catchBatchService;
    @Resource(name="speciesBatchPersistenceService")
    protected SpeciesBatchPersistenceService speciesBatchService;
    @Resource(name="benthosBatchPersistenceService")
    protected BenthosBatchPersistenceService benthosBatchService;
    @Resource(name="marineLitterBatchPersistenceService")
    protected MarineLitterBatchPersistenceService marineLitterBatchService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchService;
    @Resource(name="protocolPersistenceService")
    protected ProtocolPersistenceService protocolService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentService;
    @Resource(name="technicalPersistenceService")
    protected TechnicalPersistenceService technicalPersistenceService;
    protected boolean close;

    @Override
    public String getImplementationName() {
        return "Persistence Adagio implementation";
    }

    @Override
    public void clearAllCaches() {
        this.technicalPersistenceService.clearAllCaches();
    }

    @Override
    public <V> V invoke(Callable<V> call) {
        return this.technicalPersistenceService.invoke(call);
    }

    @Override
    public Version getDbVersion() {
        return this.technicalPersistenceService.getDbVersion();
    }

    @Override
    public Version getApplicationVersion() {
        return this.technicalPersistenceService.getApplicationVersion();
    }

    @Override
    public void updateSchema() {
        this.technicalPersistenceService.updateSchema();
    }

    @Override
    public void sanityDb() {
        this.technicalPersistenceService.sanityDb();
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.technicalPersistenceService.isTemporary(entity);
    }

    @Override
    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
        this.caracteristicService.init();
        this.gearService.init();
        this.locationService.init();
        this.objectTypeService.init();
        this.personService.init();
        this.speciesService.init();
        this.vesselService.init();
        this.programService.init();
        this.cruiseService.init();
        this.fishingOperationService.init();
        this.catchBatchService.init();
        this.speciesBatchService.init();
        this.benthosBatchService.init();
        this.marineLitterBatchService.init();
        this.accidentalBatchService.init();
        this.individualObservationBatchService.init();
        this.protocolService.init();
        this.attachmentService.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.close) {
            this.close = true;
            TuttiPersistenceImpl tuttiPersistenceImpl = this;
            synchronized (tuttiPersistenceImpl) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Close persistence driver " + this.getImplementationName()));
                }
                this.caracteristicService.close();
                this.gearService.close();
                this.locationService.close();
                this.objectTypeService.close();
                this.personService.close();
                this.speciesService.close();
                this.vesselService.close();
                this.programService.close();
                this.cruiseService.close();
                this.fishingOperationService.close();
                this.catchBatchService.close();
                this.speciesBatchService.close();
                this.benthosBatchService.close();
                this.marineLitterBatchService.close();
                this.accidentalBatchService.close();
                this.individualObservationBatchService.close();
                this.protocolService.close();
                this.attachmentService.close();
                TuttiPersistenceServiceLocator.shutdownTutti();
            }
        }
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.caracteristicService.getAllCaracteristic();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.caracteristicService.getAllCaracteristicWithProtected();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        return this.caracteristicService.getAllCaracteristicForSampleCategory();
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.caracteristicService.getAllNumericCaracteristic();
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.caracteristicService.getSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.caracteristicService.getSexCaracteristic();
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.caracteristicService.getSortedUnsortedCaracteristic();
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.caracteristicService.getMaturityCaracteristic();
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        return this.caracteristicService.getAgeCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.caracteristicService.getMarineLitterCategoryCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.caracteristicService.getMarineLitterSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.caracteristicService.getVerticalOpeningCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        return this.caracteristicService.getHorizontalOpeningWingsCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.caracteristicService.getHorizontalOpeningDoorCaracteristic();
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.caracteristicService.getDeadOrAliveCaracteristic();
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        return this.caracteristicService.getPmfmIdCaracteristic();
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.caracteristicService.getWeightMeasuredCaracteristic();
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        return this.caracteristicService.getCaracteristic(pmfmId);
    }

    @Override
    public boolean isVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.caracteristicService.isVracBatch(speciesBatch);
    }

    @Override
    public Predicate<SpeciesAbleBatch> getVracBatchPredicate() {
        return this.caracteristicService.getVracBatchPredicate();
    }

    @Override
    public boolean isHorsVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.caracteristicService.isHorsVracBatch(speciesBatch);
    }

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        return this.locationService.getAllProgramZone();
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        return this.locationService.getAllCountry();
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        return this.locationService.getAllHarbour();
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.locationService.getAllFishingOperationStrata(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.locationService.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.locationService.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationIdByLatLong(latitude, longitude);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        return this.locationService.getLocation(id);
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        return this.objectTypeService.getAllObjectType();
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        return this.objectTypeService.getObjectType(objectTypeCode);
    }

    @Override
    public List<Gear> getAllScientificGear() {
        return this.gearService.getAllScientificGear();
    }

    @Override
    public List<Gear> getAllFishingGear() {
        return this.gearService.getAllFishingGear();
    }

    @Override
    public Gear getGear(Integer gearId) {
        return this.gearService.getGear(gearId);
    }

    @Override
    public boolean isTemporaryGearUsed(Integer id) {
        return this.gearService.isTemporaryGearUsed(id);
    }

    @Override
    public Collection<Gear> importTemporaryGear(Collection<Gear> gears) {
        return this.gearService.importTemporaryGear(gears);
    }

    @Override
    public void replaceGear(Gear source, Gear target, boolean delete) {
        this.gearService.replaceGear(source, target, delete);
    }

    @Override
    public void deleteTemporaryGear(Integer id) {
        this.gearService.deleteTemporaryGear(id);
    }

    @Override
    public void deleteTemporaryGears(Collection<Integer> id) {
        this.gearService.deleteTemporaryGears(id);
    }

    @Override
    public List<Species> getAllSpecies() {
        List<Species> result = this.speciesService.getAllSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        List<Species> result = this.speciesService.getAllReferentSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.speciesService.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        return this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxonId);
    }

    @Override
    public boolean isTemporarySpeciesUsed(Integer referenceTaxonId) {
        SpeciesProtocol speciesProtocol;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesOrBenthosProtocol(protocol, referenceTaxonId)) != null) {
            return true;
        }
        return this.speciesService.isTemporarySpeciesUsed(referenceTaxonId);
    }

    @Override
    public Collection<Species> importTemporarySpecies(Collection<Species> species) {
        return this.speciesService.importTemporarySpecies(species);
    }

    @Override
    public void replaceSpecies(Species source, Species target, boolean delete) {
        SpeciesProtocol speciesProtocol;
        this.speciesService.replaceSpecies(source, target, delete);
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesOrBenthosProtocol(protocol, source.getReferenceTaxonId())) != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Change referenceTaxonId " + source.getReferenceTaxonId() + " to " + target.getReferenceTaxonId() + " in protocol."));
            }
            speciesProtocol.setSpeciesReferenceTaxonId(target.getReferenceTaxonId());
            this.saveProtocol(protocol);
        }
    }

    @Override
    public void deleteTemporarySpecies(Integer referenceTaxonId) {
        this.speciesService.deleteTemporarySpecies(referenceTaxonId);
    }

    @Override
    public void deleteTemporarySpecies(Collection<Integer> referenceTaxonIds) {
        this.speciesService.deleteTemporarySpecies(referenceTaxonIds);
    }

    @Override
    public List<Person> getAllPerson() {
        return this.personService.getAllPerson();
    }

    @Override
    public Person getPerson(Integer personId) {
        return this.personService.getPerson(personId);
    }

    @Override
    public boolean isTemporaryPersonUsed(Integer id) {
        return this.personService.isTemporaryPersonUsed(id);
    }

    @Override
    public Collection<Person> importTemporaryPerson(Collection<Person> persons) {
        return this.personService.importTemporaryPerson(persons);
    }

    @Override
    public void replacePerson(Person source, Person target, boolean delete) {
        this.personService.replacePerson(source, target, delete);
    }

    @Override
    public void deleteTemporaryPerson(Integer id) {
        this.personService.deleteTemporaryPerson(id);
    }

    @Override
    public void deleteTemporaryPersons(Collection<Integer> ids) {
        this.personService.deleteTemporaryPersons(ids);
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        return this.vesselService.getAllScientificVessel();
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        return this.vesselService.getAllFishingVessel();
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return this.vesselService.getVessel(vesselCode);
    }

    @Override
    public boolean isTemporaryVesselUsed(String code) {
        return this.vesselService.isTemporaryVesselUsed(code);
    }

    @Override
    public Collection<Vessel> importTemporaryVessel(Collection<Vessel> vessels) {
        return this.vesselService.importTemporaryVessel(vessels);
    }

    @Override
    public void replaceVessel(Vessel source, Vessel target, boolean delete) {
        this.vesselService.replaceVessel(source, target, delete);
    }

    @Override
    public void deleteTemporaryVessel(String code) {
        this.vesselService.deleteTemporaryVessel(code);
    }

    @Override
    public void deleteTemporaryVessels(Collection<String> codes) {
        this.vesselService.deleteTemporaryVessels(codes);
    }

    @Override
    public List<Attachment> getAllAttachments(ObjectTypeCode objectType, Integer objectId) {
        return this.attachmentService.getAllAttachments(objectType, objectId);
    }

    @Override
    public File getAttachmentFile(String attachmentId) {
        return this.attachmentService.getAttachmentFile(attachmentId);
    }

    @Override
    public Attachment createAttachment(Attachment attachment, File file) {
        return this.attachmentService.createAttachment(attachment, file);
    }

    @Override
    public Attachment saveAttachment(Attachment attachment) {
        return this.attachmentService.saveAttachment(attachment);
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        this.attachmentService.deleteAttachment(attachmentId);
    }

    @Override
    public void deleteAllAttachment(ObjectTypeCode objectType, Integer ... objectIds) {
        this.attachmentService.deleteAllAttachment(objectType, objectIds);
    }

    @Override
    public List<Program> getAllProgram() {
        return this.programService.getAllProgram();
    }

    @Override
    public Program getProgram(String id) {
        return this.programService.getProgram(id);
    }

    @Override
    public Program createProgram(Program bean) {
        return this.programService.createProgram(bean);
    }

    @Override
    public Program saveProgram(Program bean) {
        return this.programService.saveProgram(bean);
    }

    @Override
    public List<Cruise> getAllCruise(String programId) {
        return this.cruiseService.getAllCruise(programId);
    }

    @Override
    public Cruise getCruise(String id) {
        return this.cruiseService.getCruise(id);
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        return this.cruiseService.createCruise(bean);
    }

    @Override
    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        return this.cruiseService.saveCruise(bean, updateVessel, updateGear);
    }

    @Override
    public void setCruiseReadyToSynch(Integer cruiseId) {
        this.cruiseService.setCruiseReadyToSynch(cruiseId);
    }

    @Override
    public CaracteristicMap getGearCaracteristics(String cruiseId, String gearId, short rankOrder) {
        return this.cruiseService.getGearCaracteristics(cruiseId, gearId, rankOrder);
    }

    @Override
    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        return this.cruiseService.isOperationUseGears(cruiseId, gears);
    }

    @Override
    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.cruiseService.saveGearCaracteristics(gear, cruise);
    }

    @Override
    public TuttiProtocol getProtocol() {
        return this.protocolService.getProtocol();
    }

    @Override
    public void setProtocol(TuttiProtocol protocol) {
        this.protocolService.setProtocol(protocol);
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.protocolService.isProtocolExist(id);
    }

    @Override
    public List<String> getAllProtocolNames() {
        return this.protocolService.getAllProtocolId();
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        return this.protocolService.getAllProtocol();
    }

    @Override
    public List<String> getAllProtocolId() {
        return this.protocolService.getAllProtocolId();
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.protocolService.saveProtocol(bean);
    }

    @Override
    public void deleteProtocol(String id) {
        this.protocolService.deleteProtocol(id);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.protocolService.createProtocol(bean);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        Species species;
        String taxonId;
        SpeciesProtocol speciesProtocol;
        Iterator<SpeciesProtocol> iterator;
        TuttiProtocol protocol = this.protocolService.getProtocol(id);
        List<Species> allReferentSpecies = this.getAllReferentSpecies();
        Map<String, Species> map = Speciess.splitByTaxonId(allReferentSpecies);
        if (!protocol.isSpeciesEmpty()) {
            iterator = protocol.getSpecies().iterator();
            while (iterator.hasNext()) {
                speciesProtocol = iterator.next();
                taxonId = String.valueOf(speciesProtocol.getSpeciesReferenceTaxonId());
                species = map.get(taxonId);
                if (species != null) continue;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not find protocol species " + taxonId + " (" + speciesProtocol.getSpeciesSurveyCode() + ") in referential."));
                }
                iterator.remove();
            }
        }
        if (!protocol.isBenthosEmpty()) {
            iterator = protocol.getBenthos().iterator();
            while (iterator.hasNext()) {
                speciesProtocol = iterator.next();
                taxonId = String.valueOf(speciesProtocol.getSpeciesReferenceTaxonId());
                species = map.get(taxonId);
                if (species != null) continue;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not find protocol benthos " + taxonId + " (" + speciesProtocol.getSpeciesSurveyCode() + ") in referential."));
                }
                iterator.remove();
            }
        }
        return protocol;
    }

    @Override
    public int getFishingOperationCount(String cruiseId) {
        return this.fishingOperationService.getFishingOperationCount(cruiseId);
    }

    @Override
    public List<String> getAllFishingOperationIds(String cruiseId) {
        return this.fishingOperationService.getAllFishingOperationIds(cruiseId);
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.fishingOperationService.getAllFishingOperation(cruiseId);
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        return this.fishingOperationService.getFishingOperation(id);
    }

    @Override
    public List<Vessel> getFishingOperationSecondaryVessel(String fishingOperationId) {
        return this.fishingOperationService.getFishingOperationSecondaryVessel(fishingOperationId);
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.createFishingOperation(bean);
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.saveFishingOperation(bean);
    }

    @Override
    public Collection<FishingOperation> saveFishingOperations(Collection<FishingOperation> beans) {
        return this.fishingOperationService.saveFishingOperations(beans);
    }

    @Override
    public void deleteFishingOperation(String id) {
        this.fishingOperationService.deleteFishingOperation(id);
    }

    @Override
    public boolean isFishingOperationWithCatchBatch(String operationId) {
        return this.catchBatchService.isFishingOperationWithCatchBatch(operationId);
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.catchBatchService.getCatchBatchFromFishingOperation(id);
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.catchBatchService.createCatchBatch(bean);
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.catchBatchService.saveCatchBatch(bean);
    }

    @Override
    public void deleteCatchBatch(String fishingOperationId) {
        this.catchBatchService.deleteCatchBatch(fishingOperationId);
    }

    @Override
    public void recomputeCatchBatchSampleRatios(String fishingOperationId) {
        this.catchBatchService.recomputeCatchBatchSampleRatios(fishingOperationId);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.speciesBatchService.getRootSpeciesBatch(fishingOperationId, validateTree);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.speciesBatchService.createSpeciesBatch(bean, parentBatchId);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.speciesBatchService.saveSpeciesBatch(bean);
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        this.speciesBatchService.deleteSpeciesBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        this.speciesBatchService.deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.speciesBatchService.changeSpeciesBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.speciesBatchService.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.speciesBatchService.getAllSpeciesBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.speciesBatchService.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    @Override
    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.benthosBatchService.getRootBenthosBatch(fishingOperationId, validateTree);
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        return this.benthosBatchService.createBenthosBatch(bean, parentBatchId);
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.benthosBatchService.saveBenthosBatch(bean);
    }

    @Override
    public void deleteBenthosBatch(String id) {
        this.benthosBatchService.deleteBenthosBatch(id);
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        this.benthosBatchService.deleteBenthosSubBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.benthosBatchService.changeBenthosBatchSpecies(batchId, species);
    }

    @Override
    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.benthosBatchService.getAllBenthosBatchFrequency(benthosBatchId);
    }

    @Override
    public Multimap<Species, BenthosBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<BenthosBatch> batchContainer) {
        return this.benthosBatchService.getAllBenthosBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        return this.benthosBatchService.saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        return this.marineLitterBatchService.getRootMarineLitterBatch(fishingOperationId);
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.marineLitterBatchService.createMarineLitterBatch(bean);
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.marineLitterBatchService.saveMarineLitterBatch(bean);
    }

    @Override
    public void deleteMarineLitterBatch(String id) {
        this.marineLitterBatchService.deleteMarineLitterBatch(id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.accidentalBatchService.getAllAccidentalBatch(fishingOperationId);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.createAccidentalBatch(bean);
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.saveAccidentalBatch(bean);
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.accidentalBatchService.deleteAccidentalBatch(id);
    }

    @Override
    public void deleteAccidentalBatchForFishingOperation(String fishingOperationId) {
        this.accidentalBatchService.deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        return this.individualObservationBatchService.getAllIndividualObservationBatch(fishingOperationId);
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.individualObservationBatchService.createIndividualObservationBatch(bean);
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.individualObservationBatchService.saveIndividualObservationBatch(bean);
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        this.individualObservationBatchService.deleteIndividualObservationBatch(id);
    }

    @Override
    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        this.individualObservationBatchService.deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
    }

    protected void setSpeciesSurveyCode(List<Species> speciesList, TuttiProtocol protocol) {
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            Integer taxonId;
            String surveyCode;
            TreeMap surveyCodeByTaxonId = Maps.newTreeMap();
            if (!protocol.isSpeciesEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode)) continue;
                    taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                    surveyCodeByTaxonId.put(taxonId, surveyCode);
                }
            }
            if (!protocol.isBenthosEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                    String oldSurveyCode;
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode) || (oldSurveyCode = surveyCodeByTaxonId.put(taxonId = speciesProtocol.getSpeciesReferenceTaxonId(), surveyCode)) == null || !log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("Detect a species in both species and benthos protocol: taxonId=%d, species surveyCode=%s, benthos surveyCode=%s", taxonId, oldSurveyCode, surveyCode));
                }
            }
            for (Species species : speciesList) {
                Integer taxonId2 = species.getReferenceTaxonId();
                String surveyCode2 = (String)surveyCodeByTaxonId.get(taxonId2);
                species.setSurveyCode(surveyCode2);
            }
        }
    }
}

