/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public class TaskPaneAddon
extends AbstractComponentAddon {
    public TaskPaneAddon() {
        super("JXTaskPane");
    }

    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        Font taskPaneFont = UIManagerExt.getSafeFont((Object)"Label.font", (Font)new Font("Dialog", 0, 12));
        taskPaneFont = taskPaneFont.deriveFont(1);
        ColorUIResource menuBackground = new ColorUIResource(SystemColor.menu);
        defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI");
        defaults.add((Object)"TaskPane.font", (Object)new FontUIResource(taskPaneFont));
        defaults.add((Object)"TaskPane.background", (Object)UIManagerExt.getSafeColor((Object)"List.background", (Color)new ColorUIResource(Color.decode("#005C5C"))));
        defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(menuBackground.darker()));
        defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)menuBackground);
        defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)menuBackground);
        defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(SystemColor.menuText));
        defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(SystemColor.menuText.brighter()));
        defaults.add((Object)"TaskPane.animate", (Object)Boolean.TRUE);
        defaults.add((Object)"TaskPane.focusInputMap", (Object)new UIDefaults.LazyInputMap(new Object[]{"ENTER", "toggleCollapsed", "SPACE", "toggleCollapsed"}));
    }

    protected void addLinuxDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addMetalDefaults(addon, defaults);
    }

    protected void addMetalDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addMetalDefaults(addon, defaults);
        if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
            defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI");
        } else {
            defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.metal.MetalTaskPaneUI");
        }
        defaults.add((Object)"TaskPane.foreground", (Object)UIManager.getColor("activeCaptionText"));
        defaults.add((Object)"TaskPane.background", (Object)MetalLookAndFeel.getControl());
        defaults.add((Object)"TaskPane.specialTitleBackground", (Object)MetalLookAndFeel.getPrimaryControl());
        defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)MetalLookAndFeel.getPrimaryControl());
        defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)MetalLookAndFeel.getPrimaryControlHighlight());
        defaults.add((Object)"TaskPane.titleForeground", (Object)MetalLookAndFeel.getControlTextColor());
        defaults.add((Object)"TaskPane.specialTitleForeground", (Object)MetalLookAndFeel.getControlTextColor());
        defaults.add((Object)"TaskPane.borderColor", (Object)MetalLookAndFeel.getPrimaryControl());
        defaults.add((Object)"TaskPane.titleOver", (Object)new ColorUIResource(MetalLookAndFeel.getControl().darker()));
        defaults.add((Object)"TaskPane.specialTitleOver", (Object)MetalLookAndFeel.getPrimaryControlHighlight());
    }

    protected void addWindowsDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addWindowsDefaults(addon, defaults);
        if (addon instanceof WindowsLookAndFeelAddons) {
            defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.windows.WindowsTaskPaneUI");
            String xpStyle = OS.getWindowsVisualStyle();
            if ("HomeStead".equalsIgnoreCase(xpStyle)) {
                defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(86, 102, 45));
                defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(246, 246, 236));
                defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(224, 231, 184));
                defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(224, 231, 184));
                defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(86, 102, 45));
                defaults.add((Object)"TaskPane.titleOver", (Object)new ColorUIResource(114, 146, 29));
                defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(86, 102, 45));
                defaults.add((Object)"TaskPane.specialTitleOver", (Object)new ColorUIResource(114, 146, 29));
                defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(Color.WHITE));
            } else if ("Metallic".equalsIgnoreCase(xpStyle)) {
                defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(Color.BLACK));
                defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(240, 241, 245));
                defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(222, 222, 222));
                defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(214, 215, 224));
                defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(Color.BLACK));
                defaults.add((Object)"TaskPane.titleOver", (Object)new ColorUIResource(126, 124, 124));
                defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.BLACK));
                defaults.add((Object)"TaskPane.specialTitleOver", (Object)new ColorUIResource(126, 124, 124));
                defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(Color.WHITE));
            } else if (OS.isWindowsVista()) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource((Color)toolkit.getDesktopProperty("win.3d.backgroundColor")));
                defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(33, 89, 201));
                defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource((Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionColor")));
                defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource((Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionTextColor")));
                defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(Color.WHITE));
            } else {
                defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(214, 223, 247));
                defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(33, 89, 201));
                defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(199, 212, 247));
                defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(33, 89, 201));
                defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.WHITE));
                defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(Color.WHITE));
            }
        }
        if (addon instanceof WindowsClassicLookAndFeelAddons) {
            defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.windows.WindowsClassicTaskPaneUI");
            defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(Color.BLACK));
            defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(Color.WHITE));
            defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(10, 36, 106));
            defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(212, 208, 200));
            defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(212, 208, 200));
            defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(Color.BLACK));
            defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.WHITE));
            defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(212, 208, 200));
        }
    }

    protected void addMacDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addMacDefaults(addon, defaults);
        defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI");
        defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(245, 245, 245));
        defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(Color.BLACK));
        defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(188, 188, 188));
        defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.BLACK));
        defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(250, 250, 250));
        defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(188, 188, 188));
        defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(97, 97, 97));
        defaults.add((Object)"TaskPane.titleOver", (Object)new ColorUIResource(125, 125, 97));
        defaults.add((Object)"TaskPane.specialTitleOver", (Object)new ColorUIResource(125, 125, 97));
    }

    protected void addNimbusDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addNimbusDefaults(addon, defaults);
        defaults.add((Object)"swingx/TaskPaneUI", (Object)"org.jdesktop.swingx.plaf.nimbus.NimbusTaskPaneUI");
        defaults.add((Object)"TaskPane.foreground", (Object)new ColorUIResource(186, 190, 198));
        defaults.add((Object)"TaskPane.background", (Object)new ColorUIResource(214, 217, 223));
        defaults.add((Object)"TaskPane.specialTitleBackground", (Object)new ColorUIResource(169, 176, 190));
        defaults.add((Object)"TaskPane.titleBackgroundGradientStart", (Object)new ColorUIResource(214, 217, 223));
        defaults.add((Object)"TaskPane.titleBackgroundGradientEnd", (Object)new ColorUIResource(247, 248, 250));
        defaults.add((Object)"TaskPane.titleForeground", (Object)new ColorUIResource(Color.BLACK));
        defaults.add((Object)"TaskPane.specialTitleForeground", (Object)new ColorUIResource(Color.BLACK));
        defaults.add((Object)"TaskPane.borderColor", (Object)new ColorUIResource(146, 151, 161));
        defaults.add((Object)"TaskPane.titleOver", (Object)new ColorUIResource(57, 105, 138));
        defaults.add((Object)"TaskPane.specialTitleOver", (Object)new ColorUIResource(57, 105, 138));
    }
}

