/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class SelectServiceHandler
implements DiscoveryListener {
    private DiscoveryAgent agent;
    private Object inquiryCompletedEvent = new Object();
    private boolean inquiryCompleted;
    private Object serviceSearchCompletedEvent = new Object();
    private boolean serviceSearchCompleted;
    private Hashtable devicesProcessed = new Hashtable();
    private Vector serviceSearchDeviceQueue = new Vector();
    private ServiceRecord servRecordDiscovered;
    private static int threadNumber;

    private static synchronized int nextThreadNum() {
        return threadNumber++;
    }

    public SelectServiceHandler(DiscoveryAgent agent) {
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        Object sr;
        int i;
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        switch (security) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        RemoteDevice[] devs = this.agent.retrieveDevices(1);
        for (i = 0; devs != null && i < devs.length; ++i) {
            sr = this.findServiceOnDevice(uuid, devs[i]);
            if (sr == null) continue;
            return sr.getConnectionURL(security, master);
        }
        devs = this.agent.retrieveDevices(0);
        for (i = 0; devs != null && i < devs.length; ++i) {
            sr = this.findServiceOnDevice(uuid, devs[i]);
            if (sr == null) continue;
            return sr.getConnectionURL(security, master);
        }
        ParallelSearchServicesThread t = new ParallelSearchServicesThread(uuid);
        t.start();
        sr = this.inquiryCompletedEvent;
        synchronized (sr) {
            if (!this.agent.startInquiry(10390323, this)) {
                return null;
            }
            while (!this.inquiryCompleted) {
                try {
                    this.inquiryCompletedEvent.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            this.agent.cancelInquiry(this);
        }
        if (this.servRecordDiscovered == null && !t.processedAll()) {
            sr = this.serviceSearchDeviceQueue;
            synchronized (sr) {
                this.serviceSearchDeviceQueue.notifyAll();
            }
            try {
                t.join();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        t.interrupt();
        if (this.servRecordDiscovered != null) {
            return this.servRecordDiscovered.getConnectionURL(security, master);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRecord findServiceOnDevice(UUID uuid, RemoteDevice device) {
        if (this.devicesProcessed.containsKey(device)) {
            return null;
        }
        this.devicesProcessed.put(device, device);
        DebugLog.debug("searchServices on ", device);
        Object object = this.serviceSearchCompletedEvent;
        synchronized (object) {
            try {
                this.serviceSearchCompleted = false;
                this.agent.searchServices(null, new UUID[]{uuid}, device, this);
            }
            catch (BluetoothStateException e) {
                DebugLog.error("searchServices", e);
                return null;
            }
            while (!this.serviceSearchCompleted) {
                try {
                    this.serviceSearchCompletedEvent.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
        return this.servRecordDiscovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devicesProcessed.containsKey(btDevice)) {
            return;
        }
        Vector vector = this.serviceSearchDeviceQueue;
        synchronized (vector) {
            this.serviceSearchDeviceQueue.addElement(btDevice);
            this.serviceSearchDeviceQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        Object object = this.inquiryCompletedEvent;
        synchronized (object) {
            this.inquiryCompleted = true;
            this.inquiryCompletedEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        Object object = this.serviceSearchCompletedEvent;
        synchronized (object) {
            this.serviceSearchCompleted = true;
            this.serviceSearchCompletedEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        if (servRecord.length > 0 && this.servRecordDiscovered == null) {
            this.servRecordDiscovered = servRecord[0];
            Object object = this.serviceSearchCompletedEvent;
            synchronized (object) {
                this.serviceSearchCompleted = true;
                this.serviceSearchCompletedEvent.notifyAll();
            }
            object = this.inquiryCompletedEvent;
            synchronized (object) {
                this.inquiryCompleted = true;
                this.inquiryCompletedEvent.notifyAll();
            }
        }
    }

    private class ParallelSearchServicesThread
    extends Thread {
        private boolean stoped = false;
        private int processedNext = 0;
        private int processedSize = 0;
        private UUID uuid;

        ParallelSearchServicesThread(UUID uuid) {
            super("SelectServiceThread-" + SelectServiceHandler.nextThreadNum());
            this.uuid = uuid;
        }

        boolean processedAll() {
            return this.processedNext == SelectServiceHandler.this.serviceSearchDeviceQueue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            this.stoped = true;
            Vector vector = SelectServiceHandler.this.serviceSearchDeviceQueue;
            synchronized (vector) {
                SelectServiceHandler.this.serviceSearchDeviceQueue.notifyAll();
            }
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (!this.stoped && SelectServiceHandler.this.servRecordDiscovered == null) {
                Vector vector = SelectServiceHandler.this.serviceSearchDeviceQueue;
                synchronized (vector) {
                    if (SelectServiceHandler.this.inquiryCompleted && this.processedSize == SelectServiceHandler.this.serviceSearchDeviceQueue.size()) {
                        return;
                    }
                    if (this.processedSize == SelectServiceHandler.this.serviceSearchDeviceQueue.size()) {
                        try {
                            SelectServiceHandler.this.serviceSearchDeviceQueue.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    this.processedSize = SelectServiceHandler.this.serviceSearchDeviceQueue.size();
                }
                for (int i = this.processedNext; i < this.processedSize; ++i) {
                    RemoteDevice btDevice = (RemoteDevice)SelectServiceHandler.this.serviceSearchDeviceQueue.elementAt(i);
                    if (SelectServiceHandler.this.findServiceOnDevice(this.uuid, btDevice) != null) break block5;
                }
                this.processedNext = this.processedSize + 1;
            }
        }
    }
}

