/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.v4.PageHintWriterV4;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class FixedLayoutPageHintWriter
extends PageHintWriterV4
implements IPageHintWriter {
    public FixedLayoutPageHintWriter(IDocArchiveWriter writer) throws IOException {
        super(writer);
    }

    @Override
    protected void init(IDocArchiveWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.hintsStream = writer.createRandomAccessStream("/pages");
            this.hintsStream.writeInt(6);
            this.indexStream = writer.createRandomAccessStream("/pages_index");
            this.indexStream.writeLong(0L);
            this.indexStream.writeLong(-1L);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    protected void writePageHint(DataOutputStream out, IPageHint hint) throws IOException {
        IOUtil.writeLong(out, hint.getPageNumber());
        IOUtil.writeString(out, hint.getMasterPage());
        int sectionCount = hint.getSectionCount();
        IOUtil.writeInt(out, sectionCount);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = hint.getSection(i);
            section.write(out);
            ++i;
        }
        int hintSize = hint.getUnresolvedRowCount();
        IOUtil.writeInt(out, hintSize);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = hint.getUnresolvedRowHint(i2);
            rowHint.writeObject(out);
            ++i2;
        }
        int columnHintSize = hint.getTableColumnHintCount();
        IOUtil.writeInt(out, columnHintSize);
        int i3 = 0;
        while (i3 < columnHintSize) {
            TableColumnHint columnHint = hint.getTableColumnHint(i3);
            IOUtil.writeString(out, columnHint.getTableId());
            IOUtil.writeInt(out, columnHint.getStart());
            IOUtil.writeInt(out, columnHint.getColumnCount());
            ++i3;
        }
        Collection<PageVariable> variables = hint.getPageVariables();
        this.writePageVariables(out, variables);
    }

    @Override
    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt(out, 0);
            return;
        }
        IOUtil.writeInt(out, indexes.length);
        int i = 0;
        while (i < indexes.length) {
            IOUtil.writeString(out, indexes[i].getInstanceID().toString());
            IOUtil.writeLong(out, indexes[i].getOffset());
            ++i;
        }
    }
}

