/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.DefaultConfigLoaderManager;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;

public abstract class AbstractEmitterDescriptor
implements IEmitterDescriptor {
    protected Map initParams = null;
    protected Locale locale;
    protected Map<String, RenderOptionDefn> renderOptionDefns = new HashMap<String, RenderOptionDefn>();
    protected IConfigurableOption[] options;
    private boolean enabled = true;

    public void setInitParameters(Map params) {
        this.initParams = params;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    protected abstract void initOptions();

    public boolean isEnabled() {
        return this.enabled;
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getID() {
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void addRenderOption(String name, RenderOptionDefn renderOptionDefn) {
        this.renderOptionDefns.put(name, renderOptionDefn);
    }

    protected void applyDefaultValues() {
        IConfigurableOption[] iConfigurableOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurableOption option = iConfigurableOptionArray[n2];
            this.applyDefaultValue(option);
            ++n2;
        }
    }

    protected boolean loadDefaultValues(String bundleName) {
        for (Map.Entry<String, RenderOptionDefn> option : DefaultConfigLoaderManager.getInstance().loadConfigFor(bundleName, this).entrySet()) {
            this.addRenderOption(option.getKey(), option.getValue());
        }
        return !this.renderOptionDefns.isEmpty();
    }

    private void applyDefaultValue(IConfigurableOption option) {
        if (this.renderOptionDefns == null || this.renderOptionDefns.isEmpty()) {
            return;
        }
        RenderOptionDefn defn = this.renderOptionDefns.get(option.getName());
        if (defn != null) {
            String value = defn.getValue();
            ConfigurableOption optionImpl = (ConfigurableOption)option;
            optionImpl.setEnabled(defn.isEnabled());
            switch (option.getDataType()) {
                case STRING: {
                    optionImpl.setDefaultValue(value);
                    break;
                }
                case BOOLEAN: {
                    optionImpl.setDefaultValue(Boolean.valueOf(value));
                    break;
                }
                case INTEGER: {
                    Integer intValue = null;
                    try {
                        intValue = Integer.decode(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(intValue);
                    break;
                }
                case FLOAT: {
                    Float floatValue = null;
                    try {
                        floatValue = Float.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(floatValue);
                    break;
                }
            }
        }
    }

    protected URL getResourceURL(String bundleName, String resourceName) {
        IBundle bundle = Platform.getBundle(bundleName);
        if (bundle != null) {
            return bundle.getEntry(resourceName);
        }
        return null;
    }
}

