/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl.util.querytextutil;

import java.util.ArrayList;
import java.util.List;

public class ColumnsInfoUtil {
    private static String EMPTY_STRING = "";
    private String[] columnNames;
    private String[] columnTypeNames;
    private String[] originalColumnNames;

    public ColumnsInfoUtil(String columnsInfo) {
        assert (columnsInfo != null);
        List<String[]> columnsInfoVector = ColumnsInfoUtil.getColumnsInfoList(columnsInfo);
        this.columnNames = new String[columnsInfoVector.size()];
        this.columnTypeNames = new String[columnsInfoVector.size()];
        this.originalColumnNames = new String[columnsInfoVector.size()];
        int i = 0;
        while (i < columnsInfoVector.size()) {
            String[] items = columnsInfoVector.get(i);
            this.columnNames[i] = items[0];
            this.originalColumnNames[i] = items[1];
            this.columnTypeNames[i] = items[2];
            ++i;
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getColumnTypeNames() {
        return this.columnTypeNames;
    }

    public String[] getOriginalColumnNames() {
        return this.originalColumnNames;
    }

    private static List<String[]> getColumnsInfoList(String columnsInfo) {
        ArrayList<String[]> columnsInfoList = new ArrayList<String[]>();
        char[] columnsInfoChars = columnsInfo.toCharArray();
        boolean isEscaped = false;
        String[] columnInfo = new String[]{EMPTY_STRING, EMPTY_STRING, EMPTY_STRING};
        int index = 0;
        int i = 0;
        while (i < columnsInfoChars.length) {
            if (columnsInfoChars[i] == '\"' || columnsInfoChars[i] == '|' || columnsInfoChars[i] == ':' || columnsInfoChars[i] == '<' || columnsInfoChars[i] == '>' || columnsInfoChars[i] == '?' || columnsInfoChars[i] == '*' || columnsInfoChars[i] == '{' || columnsInfoChars[i] == '/') {
                if (isEscaped) {
                    columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
                    isEscaped = !isEscaped;
                }
            } else if (columnsInfoChars[i] == '\\') {
                if (isEscaped) {
                    columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
                    isEscaped = !isEscaped;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (columnsInfoChars[i] == ',') {
                if (isEscaped) {
                    columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
                    isEscaped = !isEscaped;
                } else {
                    ++index;
                }
            } else if (columnsInfoChars[i] == ';' || i == columnsInfoChars.length - 1) {
                if (isEscaped) {
                    columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
                    isEscaped = !isEscaped;
                } else if (i == columnsInfoChars.length - 1) {
                    columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
                    columnsInfoList.add(columnInfo);
                } else {
                    columnsInfoList.add(columnInfo);
                    index = 0;
                    columnInfo = new String[3];
                    columnInfo[1] = columnInfo[2] = EMPTY_STRING;
                    columnInfo[0] = columnInfo[2];
                }
            } else {
                columnInfo[index] = String.valueOf(columnInfo[index]) + columnsInfoChars[i];
            }
            ++i;
        }
        return columnsInfoList;
    }

    public static boolean isColumnsInfoKeyWord(char charactor) {
        return charactor == '\"' || charactor == ';' || charactor == ',' || charactor == '|' || charactor == '\\' || charactor == '/' || charactor == '<' || charactor == '>' || charactor == '*' || charactor == ':' || charactor == '?' || charactor == '{';
    }
}

