/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern commentPattern = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern upperCasePattern = Pattern.compile(".*[A-Z].*");
    private static final Pattern lowerCasePattern = Pattern.compile(".*[a-z].*");
    private static final Pattern dashPattern = Pattern.compile("\\-\\-.*$", 8);

    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.length() == 0) {
            return null;
        }
        return returnString;
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        String stripped;
        String string = stripped = stripComments ? StringUtils.stripComments(multiLineSQL) : multiLineSQL;
        if (splitStatements) {
            return StringUtils.splitSQL(stripped, endDelimiter);
        }
        return new String[]{stripped};
    }

    public static String[] splitSQL(String multiLineSQL, String endDelimiter) {
        if (endDelimiter == null) {
            endDelimiter = ";\\s*\n|;$|\n[gG][oO]\\s*\n|\n[Gg][oO]\\s*$";
        } else if (endDelimiter.equalsIgnoreCase("go")) {
            endDelimiter = "\n[gG][oO]\\s*\n|\n[Gg][oO]\\s*$";
        }
        String[] initialSplit = multiLineSQL.split(endDelimiter);
        ArrayList<String> strings = new ArrayList<String>();
        String[] stringArray = initialSplit;
        int n = initialSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String anInitialSplit = stringArray[n2];
            String singleLineSQL = anInitialSplit.trim();
            if (singleLineSQL.length() > 0) {
                strings.add(singleLineSQL);
            }
            ++n2;
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String stripComments(String multiLineSQL) {
        String strippedSingleLines = Pattern.compile("\\s*\\-\\-.*\n").matcher(multiLineSQL).replaceAll("\n");
        strippedSingleLines = Pattern.compile("\\s*\\-\\-.*$").matcher(strippedSingleLines).replaceAll("\n");
        return Pattern.compile("/\\*.*?\\*/", 32).matcher(strippedSingleLines).replaceAll("").trim();
    }

    public static String join(String[] array, String delimiter) {
        return StringUtils.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<String> collection, String delimiter) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String val : collection) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static List<String> splitAndTrim(String s, String regex) {
        if (s == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        String[] stringArray = s.split(regex);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            returnList.add(string.trim());
            ++n2;
        }
        return returnList;
    }

    public static String repeat(String string, int times) {
        String returnString = "";
        int i = 0;
        while (i < times) {
            returnString = String.valueOf(returnString) + string;
            ++i;
        }
        return returnString;
    }

    public static String join(Integer[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        int[] ints = new int[array.length];
        int i = 0;
        while (i < ints.length) {
            ints[i] = array[i];
            ++i;
        }
        return StringUtils.join(ints, delimiter);
    }

    public static String join(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            buffer.append(val).append(delimiter);
            ++n2;
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String indent(String string) {
        return StringUtils.indent(string, 4);
    }

    public static String indent(String string, int padding) {
        String pad = StringUtils.repeat(" ", padding);
        return String.valueOf(pad) + string.replaceAll("\n", "\n" + pad);
    }

    public static String lowerCaseFirst(String string) {
        return String.valueOf(string.substring(0, 1).toLowerCase()) + string.substring(1);
    }

    public static String upperCaseFirst(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static boolean hasUpperCase(String string) {
        return upperCasePattern.matcher(string).matches();
    }

    public static boolean hasLowerCase(String string) {
        return lowerCasePattern.matcher(string).matches();
    }

    public static String standardizeLineEndings(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\r\n", "\n").replace("\r", "\n");
    }

    public static boolean isAscii(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!StringUtils.isAscii(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }
}

