/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    public static void forceDeleteOnExit(final File file) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtil.deleteDirectory(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Cannot delete " + directory.getAbsolutePath());
        }
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    FileUtil.cleanDirectory(file);
                    if (!file.delete()) {
                        throw new IOException("Cannot delete " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
                ++n2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

