/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

public class DataType {
    private String typeName;
    private Integer dataTypeId;
    private Integer columnSize;
    private ColumnSizeUnit columnSizeUnit;
    private Integer decimalDigits;
    private Integer radix;
    private Integer characterOctetLength;

    public DataType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Integer dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(Integer columnSize) {
        this.columnSize = columnSize;
    }

    public ColumnSizeUnit getColumnSizeUnit() {
        return this.columnSizeUnit;
    }

    public void setColumnSizeUnit(ColumnSizeUnit columnSizeUnit) {
        this.columnSizeUnit = columnSizeUnit;
    }

    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public String toString() {
        String value = this.typeName;
        boolean unsigned = false;
        if (value.toLowerCase().endsWith(" unsigned")) {
            value = value.substring(0, value.length() - " unsigned".length());
            unsigned = true;
        }
        if (this.columnSize != null) {
            value = String.valueOf(value) + "(";
            value = String.valueOf(value) + this.columnSize;
            if (this.decimalDigits != null) {
                value = String.valueOf(value) + ", " + this.decimalDigits;
            }
            if (this.columnSizeUnit != null && this.columnSizeUnit.equals((Object)ColumnSizeUnit.CHAR) && (this.typeName.equalsIgnoreCase("VARCHAR") || this.typeName.equalsIgnoreCase("VARCHAR2"))) {
                value = String.valueOf(value) + " " + (Object)((Object)this.columnSizeUnit);
            }
            value = String.valueOf(value) + ")";
        }
        if (unsigned) {
            value = String.valueOf(value) + " UNSIGNED";
        }
        return value;
    }

    public Integer getRadix() {
        return this.radix;
    }

    public void setRadix(Integer radix) {
        this.radix = radix;
    }

    public Integer getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(Integer characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public static enum ColumnSizeUnit {
        BYTE,
        CHAR;

    }
}

