/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.sdk.supplier.database.ConnectionConfiguration;
import liquibase.servicelocator.ServiceLocator;

public class ConnectionConfigurationFactory {
    private static ConnectionConfigurationFactory instance;
    private Map<String, Set<ConnectionConfiguration>> configsByDatabase = new HashMap<String, Set<ConnectionConfiguration>>();

    public ConnectionConfigurationFactory() {
        try {
            Class<ConnectionConfiguration>[] classes;
            Class<ConnectionConfiguration>[] classArray = classes = ServiceLocator.getInstance().findClasses(ConnectionConfiguration.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<ConnectionConfiguration> clazz = classArray[n2];
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConnectionConfigurationFactory getInstance() {
        if (instance == null) {
            instance = new ConnectionConfigurationFactory();
        }
        return instance;
    }

    public Set<ConnectionConfiguration> getConfigurations(Database database) {
        Set<ConnectionConfiguration> configurations = this.configsByDatabase.get(database.getShortName());
        if (configurations == null) {
            return new HashSet<ConnectionConfiguration>();
        }
        return configurations;
    }

    public static void reset() {
        instance = new ConnectionConfigurationFactory();
    }

    public void register(ConnectionConfiguration config) {
        String databaseShortName = config.getDatabaseShortName();
        if (!this.configsByDatabase.containsKey(databaseShortName)) {
            this.configsByDatabase.put(databaseShortName, new HashSet());
        }
        this.configsByDatabase.get(databaseShortName).add(config);
    }

    public Collection<ConnectionConfiguration> findConfigurations(List<String> descriptions) throws UnknownDatabaseException {
        ArrayList<ConnectionConfiguration> returnList = new ArrayList<ConnectionConfiguration>();
        for (String config : descriptions) {
            Map<String, String> params = this.parseConfig(config);
            if (!params.containsKey("config")) {
                params.put("config", "standard");
            }
            String databaseName = params.get("databaseName");
            String configName = params.get("config");
            Set<ConnectionConfiguration> potentialConfigurations = this.configsByDatabase.get(databaseName);
            if (potentialConfigurations == null) {
                throw new UnknownDatabaseException("No database configurations for " + databaseName);
            }
            boolean foundConfig = false;
            for (ConnectionConfiguration potential : potentialConfigurations) {
                if (!potential.getConfigurationName().equals(configName)) continue;
                if (params.containsKey("version")) {
                    potential.setVersion(params.get("version"));
                }
                if (params.containsKey("hostname")) {
                    potential.setHostname(params.get("hostname"));
                }
                returnList.add(potential);
                foundConfig = true;
                break;
            }
            if (foundConfig) continue;
            throw new UnknownDatabaseException("No database configuration of '" + config + "'");
        }
        return returnList;
    }

    private Map<String, String> parseConfig(String config) {
        String databaseName;
        HashMap<String, String> params = new HashMap<String, String>();
        if (config.contains("[")) {
            databaseName = config.replaceFirst("\\[.*", "").trim();
            String paramString = config.replaceFirst(".*\\[", "").replaceFirst("]$", "");
            String[] stringArray = paramString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyValue = stringArray[n2];
                String[] split = keyValue.split(":");
                params.put(split[0].trim(), split[1].trim());
                ++n2;
            }
        } else {
            databaseName = config;
        }
        params.put("databaseName", databaseName.trim());
        return params;
    }

    public static class UnknownDatabaseException
    extends Exception {
        public UnknownDatabaseException(String message) {
            super(message);
        }
    }
}

