/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class ClassLoaderResourceAccessor
implements ResourceAccessor {
    private ClassLoader classLoader;

    public ClassLoaderResourceAccessor() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public ClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        return this.classLoader.getResourceAsStream(file);
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        try {
            File file;
            URL fileUrl = this.classLoader.getResource(packageName);
            if (fileUrl != null && (file = new File(fileUrl.toURI())).exists() && !file.isDirectory()) {
                return new Vector<URL>(Arrays.asList(fileUrl)).elements();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.classLoader.getResources(packageName);
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String description;
        if (this.classLoader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            URL[] uRLArray = ((URLClassLoader)this.classLoader).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                urls.add(url.toExternalForm());
                ++n2;
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.classLoader.getClass().getName();
        }
        return String.valueOf(this.getClass().getName()) + "(" + description + ")";
    }
}

