/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.LiquibaseParser;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.NamespaceDetailsFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializer;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LiquibaseEntityResolver
implements EntityResolver2 {
    private LiquibaseParser parser;
    private LiquibaseSerializer serializer;
    private ResourceAccessor resourceAccessor;
    private String basePath;
    private Logger log = LogFactory.getLogger();

    public LiquibaseEntityResolver(LiquibaseSerializer serializer) {
        this.serializer = serializer;
    }

    public LiquibaseEntityResolver(LiquibaseParser parser) {
        this.parser = parser;
    }

    public void useResoureAccessor(ResourceAccessor resourceAccessor, String basePath) {
        this.resourceAccessor = resourceAccessor;
        this.basePath = basePath;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource resolved = null;
        if (systemId != null && systemId.toLowerCase().endsWith(".xsd")) {
            if (systemId.startsWith("http://www.liquibase.org/xml/ns/migrator/")) {
                systemId = systemId.replace("http://www.liquibase.org/xml/ns/migrator/", "http://www.liquibase.org/xml/ns/dbchangelog/");
            }
            resolved = this.tryResolveLiquibaseSchema(systemId, publicId);
        }
        if (resolved == null && this.resourceAccessor != null && this.basePath != null && systemId != null) {
            resolved = this.tryResolveFromResourceAccessor(systemId);
        }
        return resolved;
    }

    private InputSource tryResolveLiquibaseSchema(String systemId, String publicId) {
        if (systemId != null) {
            InputStream resourceAsStream;
            block9: {
                NamespaceDetails namespaceDetails = this.serializer != null ? NamespaceDetailsFactory.getInstance().getNamespaceDetails(this.serializer, systemId) : NamespaceDetailsFactory.getInstance().getNamespaceDetails(this.parser, systemId);
                if (namespaceDetails == null) {
                    return null;
                }
                String xsdFile = namespaceDetails.getLocalPath(systemId);
                if (xsdFile == null) {
                    return null;
                }
                try {
                    resourceAsStream = this.resourceAccessor.getResourceAsStream(xsdFile);
                    if (resourceAsStream == null) {
                        if (Thread.currentThread().getContextClassLoader() != null) {
                            resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsdFile);
                        }
                        if (resourceAsStream == null) {
                            resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(xsdFile);
                        }
                    }
                    if (resourceAsStream != null) break block9;
                    return null;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            InputSource source = new InputSource(resourceAsStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }

    private InputSource tryResolveFromResourceAccessor(String systemId) {
        InputStream resourceAsStream;
        block3: {
            String path = FilenameUtils.concat(this.basePath, systemId);
            try {
                resourceAsStream = this.resourceAccessor.getResourceAsStream(path);
                if (resourceAsStream != null) break block3;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return new InputSource(resourceAsStream);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.log.warning("Current XML parsers seems to not support EntityResolver2. External entities won't be correctly loaded");
        return this.tryResolveLiquibaseSchema(systemId, publicId);
    }
}

