/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype;

import liquibase.util.StringUtils;

public class DatabaseDataType {
    private String type;

    public DatabaseDataType(String type) {
        this.type = type;
    }

    public void addAdditionalInformation(String additionalInformation) {
        if (additionalInformation != null) {
            this.type = String.valueOf(this.type) + " " + additionalInformation;
        }
    }

    public DatabaseDataType(String name, Object ... parameters) {
        this.type = name;
        String[] stringParams = new String[parameters.length];
        if (parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                stringParams[i] = parameters[i] == null ? "NULL" : parameters[i].toString();
                ++i;
            }
            this.type = String.valueOf(this.type) + "(" + StringUtils.join(stringParams, ", ") + ")";
        }
    }

    public boolean isAutoIncrement() {
        return this.type.equalsIgnoreCase("serial") || this.type.equalsIgnoreCase("bigserial");
    }

    public String toSql() {
        return this.toString();
    }

    public String toString() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

