/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.socket;

import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.socket.SynchroHttpHandler;
import fr.ifremer.adagio.synchro.socket.SynchroRequestListenerThread;
import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class SynchroHttpServer {
    private static final Log log = LogFactory.getLog(SynchroHttpServer.class);

    public void start() throws Exception {
        SynchroConfiguration config = SynchroConfiguration.getInstance();
        int port = config.getServerPort();
        boolean useSsl = port == 8443 || port == 443;
        File dataDirectory = config.getDataDirectory();
        if (!dataDirectory.exists() || !dataDirectory.isDirectory()) {
            log.error((Object)("Working directory not exists: " + dataDirectory));
            System.exit(0);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting synchronization server...");
            log.info((Object)(" Port: " + port));
            if (useSsl) {
                log.info((Object)" SSL: enable");
            }
        }
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("Test/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
        UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
        SynchroHttpHandler baseHandler = new SynchroHttpHandler(dataDirectory);
        reqistry.register("*", (HttpRequestHandler)baseHandler);
        HttpService httpService = new HttpService(httpproc, (HttpRequestHandlerMapper)reqistry);
        SSLServerSocketFactory sf = null;
        if (useSsl) {
            File sslKeyStoreFile;
            ClassLoader cl = SynchroHttpServer.class.getClassLoader();
            URL url = cl.getResource((sslKeyStoreFile = config.getServerSslKeyStore()).getPath());
            if (url == null) {
                log.error((Object)("Keystore file not found: " + sslKeyStoreFile.getPath()));
                System.exit(1);
            }
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(url.openStream(), "secret".toCharArray());
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keystore, "secret".toCharArray());
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, null, null);
            sf = sslcontext.getServerSocketFactory();
        }
        SynchroRequestListenerThread t = new SynchroRequestListenerThread(port, httpService, sf);
        t.setDaemon(false);
        t.start();
    }
}

