/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorUtils;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class SynchroDatabaseMetadata {
    private static final Log log = LogFactory.getLog(SynchroDatabaseMetadata.class);
    private static final String TABLE_CATALOG_PATTERN = "TABLE_CAT";
    private static final String TABLE_TYPE_PATTERN = "TABLE_TYPE";
    private static final String TABLE_SCHEMA_PATTERN = "TABLE_SCHEM";
    private static final String REMARKS_PATTERN = "REMARKS";
    private static final String TABLE_NAME_PATTERN = "TABLE_NAME";
    protected final DatabaseMetadata delegate;
    protected final Map<String, SynchroTableMetadata> tables;
    protected final DatabaseMetaData meta;
    protected final Configuration configuration;
    protected final Dialect dialect;
    protected final Set<String> sequences;
    protected final String[] types;
    private SQLExceptionConverter sqlExceptionConverter;
    protected List<SynchroInterceptor> interceptors;
    protected SynchroContext context;

    public static SynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, Dialect dialect, Configuration configuration, SynchroContext context, Set<String> tableNames, boolean enableJoinMetadataLoading) {
        SynchroDatabaseMetadata result = new SynchroDatabaseMetadata(connection, dialect, configuration, context);
        result.prepare(dialect, configuration, tableNames, null, null, enableJoinMetadataLoading);
        return result;
    }

    public static SynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, Dialect dialect, Configuration configuration, SynchroContext context, Set<String> tableNames, Predicate<String> tableFilter, Predicate<SynchroColumnMetadata> columnFilter, boolean enableJoinMetadataLoading) {
        SynchroDatabaseMetadata result = new SynchroDatabaseMetadata(connection, dialect, configuration, context);
        result.prepare(dialect, configuration, tableNames, tableFilter, columnFilter, enableJoinMetadataLoading);
        return result;
    }

    public SynchroDatabaseMetadata(Connection connection, Dialect dialect, Configuration configuration, SynchroContext context) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)dialect);
        Preconditions.checkNotNull((Object)configuration);
        this.configuration = configuration;
        this.dialect = dialect;
        this.sqlExceptionConverter = DaoUtils.newSQLExceptionConverter(dialect);
        this.context = context;
        try {
            this.delegate = new DatabaseMetadata(connection, dialect, configuration, true);
            Field sqlExceptionConverterField = DatabaseMetadata.class.getDeclaredField("sqlExceptionConverter");
            sqlExceptionConverterField.setAccessible(true);
            sqlExceptionConverterField.set(this.delegate, this.sqlExceptionConverter);
            this.sequences = this.initSequences(connection, dialect);
            Field typesField = DatabaseMetadata.class.getDeclaredField("types");
            typesField.setAccessible(true);
            this.types = (String[])typesField.get(this.delegate);
            this.meta = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.persistence.dbMetadata.instanciation.error", (Object[])new Object[]{connection}), e);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.persistence.dbMetadata.instanciation.error", (Object[])new Object[]{connection}), e);
        }
        this.tables = Maps.newTreeMap();
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public SynchroContext getContext() {
        return this.context;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public int getInExpressionCountLimit() {
        return this.dialect.getInExpressionCountLimit();
    }

    public boolean isSequence(String tableName) {
        String[] strings = StringHelper.split((String)".", (String)tableName);
        return this.sequences.contains(StringHelper.toLowerCase((String)strings[strings.length - 1]));
    }

    public void prepare(Dialect dialect, Configuration configuration, Set<String> tableNames, Predicate<String> tableFilter, Predicate<SynchroColumnMetadata> columnFilter, boolean enableJoinMetadataLoading) {
        boolean enableFilter;
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(tableNames) || tableFilter != null ? 1 : 0) != 0, (Object)"One of 'tableNames' or 'tableFilter' must be set and not empty");
        boolean bl = enableFilter = tableFilter != null;
        if (!enableFilter) {
            String tablePattern;
            Iterator<String> i$ = tableNames.iterator();
            while (i$.hasNext() && !(enableFilter = (tablePattern = i$.next()).contains("%"))) {
            }
        }
        Set<String> filteredTableNames = tableNames;
        if (enableFilter) {
            filteredTableNames = CollectionUtils.isEmpty(tableNames) ? this.getTableNames(tableFilter) : this.getTableNames(tableNames, tableFilter);
        }
        String jdbcCatalog = configuration.getProperty("hibernate.default_catalog");
        String jdbcSchema = configuration.getProperty("hibernate.default_schema");
        for (String tableName : filteredTableNames) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load metas of table: " + tableName));
            }
            this.getTable(dialect, tableName, jdbcSchema, jdbcCatalog, false, columnFilter, false);
        }
        HashMap tablesByNames = Maps.newHashMap();
        for (SynchroTableMetadata table : this.tables.values()) {
            tablesByNames.put(table.getName(), table);
            if (enableJoinMetadataLoading) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load joins of table: " + table.getName()));
                }
                table.initJoins(this);
            }
            this.fireOnTableLoad(table);
        }
    }

    public SynchroTableMetadata getTable(String name) throws HibernateException {
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.configuration.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.configuration.getProperties());
        return this.getTable(this.dialect, name, defaultSchema, defaultCatalog, false, null, true);
    }

    public SynchroTableMetadata getLoadedTable(String name) throws HibernateException {
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.configuration.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.configuration.getProperties());
        return this.getLoadedTable(name, defaultSchema, defaultCatalog);
    }

    public SynchroTableMetadata getLoadedTable(String name, String schema, String catalog) throws HibernateException {
        String key = Table.qualify((String)catalog, (String)schema, (String)name).toLowerCase();
        return this.tables.get(key);
    }

    public Set<String> getTableNames(Predicate<String> tableFilter) {
        return this.getTableNames(Sets.newHashSet((Object[])new String[]{"%"}), tableFilter);
    }

    public Set<String> getTableNames(Set<String> tablePatterns, Predicate<String> tableFilter) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tablePatterns));
        HashSet tablenames = Sets.newHashSet();
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.configuration.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.configuration.getProperties());
        String[] types = null;
        types = this.configuration != null && ConfigurationHelper.getBoolean((String)"hibernate.synonyms", (Map)this.configuration.getProperties(), (boolean)false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
        ResultSet res = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting table names, using filter");
            }
            for (String tablePattern : tablePatterns) {
                res = this.meta.getTables(defaultCatalog, defaultSchema, tablePattern, types);
                while (res.next()) {
                    String tableName = res.getString(TABLE_NAME_PATTERN);
                    if (this.delegate.isSequence((Object)tableName) || tableFilter != null && !tableFilter.apply((Object)tableName)) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(" TABLE_CAT=" + res.getString(TABLE_CATALOG_PATTERN) + " " + TABLE_SCHEMA_PATTERN + "=" + res.getString(TABLE_SCHEMA_PATTERN) + " " + TABLE_NAME_PATTERN + "=" + res.getString(TABLE_NAME_PATTERN) + " " + TABLE_TYPE_PATTERN + "=" + res.getString(TABLE_TYPE_PATTERN) + " " + REMARKS_PATTERN + "=" + res.getString(REMARKS_PATTERN)));
                    }
                    tablenames.add(tableName);
                }
            }
        }
        catch (SQLException e) {
            throw this.sqlExceptionConverter.convert(e, "Retrieving database table names", "n/a");
        }
        finally {
            DaoUtils.closeSilently(res);
        }
        return tablenames;
    }

    public Set<String> getLoadedRootTableNames() {
        LinkedHashSet tablenames = Sets.newLinkedHashSet();
        for (SynchroTableMetadata table : this.tables.values()) {
            if (!table.isRoot()) continue;
            tablenames.add(table.getName());
        }
        return tablenames;
    }

    public Set<String> getLoadedTableNames() {
        LinkedHashSet tablenames = Sets.newLinkedHashSet();
        for (SynchroTableMetadata table : this.tables.values()) {
            tablenames.add(table.getName());
        }
        return tablenames;
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.meta.getExportedKeys(catalog, schema, table);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.meta.getImportedKeys(catalog, schema, table);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.meta.getPrimaryKeys(catalog, schema, table);
    }

    protected SynchroTableMetadata getTable(Dialect dialect, String name, String schema, String catalog, boolean isQuoted, Predicate<SynchroColumnMetadata> columnFilter, boolean withJoinedTables) throws HibernateException {
        String key = Table.qualify((String)catalog, (String)schema, (String)name).toLowerCase();
        SynchroTableMetadata synchroTableMetadata = this.tables.get(key);
        if (synchroTableMetadata == null) {
            TableMetadata tableMetadata = this.delegate.getTableMetadata(name.toLowerCase(), schema, catalog, isQuoted);
            Preconditions.checkNotNull((Object)tableMetadata, (Object)String.format("Could not find db table '%s' (schema=%s, catalog=%s)", name, schema, catalog));
            List<SynchroInterceptor> interceptors = this.getInterceptors(tableMetadata);
            synchroTableMetadata = new SynchroTableMetadata(this, tableMetadata, interceptors, name, this.sequences, columnFilter);
            Preconditions.checkNotNull((Object)synchroTableMetadata, (Object)("Could not load metadata for table: " + name));
            this.tables.put(key, synchroTableMetadata);
        }
        return synchroTableMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql;
        HashSet sequences = Sets.newHashSet();
        if (dialect.supportsSequences() && (sql = dialect.getQuerySequencesString()) != null) {
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    sequences.add(StringHelper.toLowerCase((String)rs.getString(1)).trim());
                }
            }
            finally {
                rs.close();
                statement.close();
            }
        }
        return sequences;
    }

    protected List<SynchroInterceptor> getInterceptors(TableMetadata table) {
        if (this.interceptors == null) {
            this.interceptors = SynchroInterceptorUtils.load(SynchroInterceptor.class, this.context);
        }
        Collection<SynchroInterceptor> filteredInterceptors = SynchroInterceptorUtils.filter(this.interceptors, this, table);
        return Lists.newArrayList(filteredInterceptors);
    }

    protected void fireOnTableLoad(SynchroTableMetadata table) {
        List<SynchroInterceptor> interceptors = table.getInterceptors();
        if (CollectionUtils.isNotEmpty(interceptors)) {
            for (SynchroInterceptor interceptor : interceptors) {
                interceptor.onTableLoad(table);
            }
        }
    }
}

