/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorChain;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class SynchroInterceptorUtils {
    private SynchroInterceptorUtils() {
    }

    public static <T, U extends SynchroInterceptor> List<U> load(Class<U> clazz, SynchroContext context) {
        ArrayList result = Lists.newArrayList();
        ServiceLoader<SynchroInterceptor> loader = ServiceLoader.load(clazz);
        for (SynchroInterceptor interceptor : loader) {
            interceptor.setContext(context);
            result.add(interceptor);
        }
        return result;
    }

    public static <T, U extends SynchroInterceptor> Collection<U> filter(List<U> interceptors, final SynchroDatabaseMetadata meta, final TableMetadata table) {
        Collection result = Collections2.filter(interceptors, (Predicate)new Predicate<SynchroInterceptor>(){

            public boolean apply(SynchroInterceptor interceptor) {
                return interceptor.apply(meta, table);
            }
        });
        return result;
    }

    public static <T, U extends SynchroInterceptor> U chain(List<U> interceptors, SynchroDatabaseMetadata meta, TableMetadata table, Class<? extends SynchroInterceptorChain> chainClazz) {
        Collection<U> filteredInterceptors = SynchroInterceptorUtils.filter(interceptors, meta, table);
        try {
            return (U)SynchroInterceptorUtils.createChain(filteredInterceptors, chainClazz);
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
    }

    public static <T, U extends SynchroInterceptor, V extends SynchroInterceptorChain> U chain(Collection<U> interceptors, Class<V> chainClazz) {
        try {
            return (U)SynchroInterceptorUtils.createChain(interceptors, chainClazz);
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
    }

    protected static <T, U extends SynchroInterceptor> SynchroInterceptorChain createChain(Collection<U> interceptors, Class<? extends SynchroInterceptorChain> chainClazz) throws InstantiationException, IllegalAccessException {
        SynchroInterceptorChain result = null;
        SynchroInterceptorChain previous = null;
        for (SynchroInterceptor interceptor : interceptors) {
            SynchroInterceptorChain newChain = null;
            newChain = interceptor instanceof SynchroInterceptorChain ? (SynchroInterceptorChain)interceptor : SynchroInterceptorUtils.encapsulate(interceptor, chainClazz);
            if (result == null) {
                result = newChain;
            } else if (previous != null) {
                previous.setNext(newChain);
            }
            previous = newChain;
        }
        return result;
    }

    protected static <T, U extends SynchroInterceptor> SynchroInterceptorChain encapsulate(U delegate, Class<? extends SynchroInterceptorChain> chainClass) throws InstantiationException, IllegalAccessException {
        SynchroInterceptorChain chain = chainClass.newInstance();
        chain.setNext(delegate);
        return chain;
    }
}

