/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorChain;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class SynchroInterceptorBase
implements SynchroInterceptorChain {
    private SynchroInterceptor next;
    private SynchroContext context;
    private boolean enableOnRead = false;
    private boolean enableOnWrite = false;

    public SynchroInterceptorBase() {
        this.next = null;
        this.context = null;
    }

    public SynchroInterceptorBase(SynchroInterceptor next) {
        this.next = next;
        this.context = null;
    }

    @Override
    public SynchroInterceptorBase clone() {
        try {
            return (SynchroInterceptorBase)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException(String.format("Could not clone the interceptor class %s. Make sure method clone() has been implemented.", this.getClass().getName()));
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException(String.format("Could not clone the interceptor class %s. Make sure method clone() has been implemented.", this.getClass().getName()));
        }
    }

    @Override
    public boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return false;
    }

    @Override
    public void setNext(SynchroInterceptor next) {
        this.next = next;
    }

    @Override
    public SynchroInterceptor getNext() {
        return this.next;
    }

    @Override
    public final void close() throws IOException {
        this.doClose();
        if (this.next != null) {
            this.next.close();
        }
    }

    @Override
    public final void onRead(Object[] data, SynchroTableDao dao) throws SQLException {
        this.doOnRead(data, dao);
        if (this.next != null) {
            this.next.onRead(data, dao);
        }
    }

    @Override
    public final void onWrite(Object[] data, String pkStr, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException {
        this.doOnWrite(data, pkStr, dao, buffer);
        if (this.next != null) {
            this.next.onWrite(data, pkStr, dao, buffer);
        }
    }

    @Override
    public Map<List<Object>, Object[]> transformExtraLocalData(SynchroTableDao localDao, SynchroTableDao remoteDao, Map<List<Object>, Object[]> extraRows) throws SQLException {
        Map<List<Object>, Object[]> result = this.doTransformExtraLocalData(localDao, remoteDao, extraRows);
        if (this.next != null) {
            result = this.next.transformExtraLocalData(localDao, remoteDao, result);
        }
        return result;
    }

    @Override
    public final String onCreateSelectQuery(SynchroTableMetadata table, String queryName, String sql) {
        String newSql = this.doCreateSelectQuery(table, queryName, sql);
        if (this.next != null) {
            newSql = this.next.onCreateSelectQuery(table, queryName, newSql != null ? newSql : sql);
        }
        return newSql;
    }

    @Override
    public final void onTableLoad(SynchroTableMetadata table) {
        this.doTableLoad(table);
        if (this.next != null) {
            this.next.onTableLoad(table);
        }
    }

    @Override
    public final void onJoinLoad(SynchroTableMetadata table, SynchroJoinMetadata join) {
        this.doJoinLoad(table, join);
        if (this.next != null) {
            this.next.onJoinLoad(table, join);
        }
    }

    @Override
    public boolean enableOnRead() {
        return this.enableOnRead;
    }

    @Override
    public boolean enableOnWrite() {
        return this.enableOnWrite;
    }

    public void setEnableOnRead(boolean enableOnRead) {
        this.enableOnRead = enableOnRead;
    }

    public void setEnableOnWrite(boolean enableOnWrite) {
        this.enableOnWrite = enableOnWrite;
    }

    @Override
    public void setContext(SynchroContext context) {
        this.context = context;
    }

    protected SynchroContext getContext() {
        return this.context;
    }

    protected void doClose() throws IOException {
    }

    protected void doTableLoad(SynchroTableMetadata table) {
    }

    protected void doJoinLoad(SynchroTableMetadata table, SynchroJoinMetadata join) {
    }

    protected String doCreateSelectQuery(SynchroTableMetadata table, String queryName, String sql) {
        String[] clauses = sql.split("(FROM)|(WHERE)");
        Preconditions.checkArgument((clauses.length == 2 || clauses.length == 3 ? 1 : 0) != 0, (Object)String.format("Bad sql query: [%s]. Expected: SELECT <...> FROM <...> WHERE <...>", sql));
        String selectClause = clauses[0];
        String fromClause = clauses[1];
        String whereClause = clauses.length == 3 ? clauses[2] : null;
        return this.doCreateSelectQuery(table, selectClause, fromClause, whereClause, queryName);
    }

    protected String doCreateSelectQuery(SynchroTableMetadata table, String selectClause, String fromClause, String whereClause, String queryName) {
        StringBuilder sb = new StringBuilder(selectClause).append(" FROM ").append(fromClause);
        if (StringUtils.isNotBlank((CharSequence)whereClause)) {
            sb.append(" WHERE ").append(whereClause);
        }
        return sb.toString();
    }

    protected void doOnRead(Object[] data, SynchroTableDao dao) throws SQLException {
    }

    protected void doOnWrite(Object[] data, String pkStr, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException {
    }

    protected Map<List<Object>, Object[]> doTransformExtraLocalData(SynchroTableDao localDao, SynchroTableDao remoteDao, Map<List<Object>, Object[]> extraRows) throws SQLException {
        return extraRows;
    }
}

