/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.GearModel;
import fr.ifremer.tutti.service.referential.GearRow;
import fr.ifremer.tutti.service.referential.ImportRequestResult;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryGearService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryGearService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportResult<Gear> importTemporaryGear(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gears from file: " + file));
        }
        ArrayList<Gear> allGears = new ArrayList<Gear>(this.persistenceService.getAllFishingGear());
        allGears.addAll(this.persistenceService.getAllScientificGear());
        ImportRequestResult<Gear, Integer> requestResult = this.processImportFile(file, allGears);
        ReferentialImportResult<Gear> result = new ReferentialImportResult<Gear>();
        if (requestResult.withEntitiesToDelete()) {
            Collection<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryGears(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            Collection<Gear> entitiesToAdd = requestResult.getEntitiesToAdd();
            Collection<Gear> entitiesAdded = this.persistenceService.importTemporaryGear(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            Collection<Gear> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            Collection<Gear> entitiesUpdated = this.persistenceService.importTemporaryGear(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        return result;
    }

    public void exportExistingTemporaryGear(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all gears from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingGear());
        targetList.addAll(this.persistenceService.getAllScientificGear());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " gears"));
        }
        List<Gear> toExport = this.persistenceService.retainTemporaryGearList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary gears"));
        }
        this.exportTemporaryGear(file, toExport);
    }

    public void exportTemporaryGearExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Gear g = Gears.newGear();
        g.setName("Gear fishing name 1");
        g.setLabel("Gear fishing label 1");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear fishing name 2");
        g.setLabel("Gear fishing label 2");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 3");
        g.setLabel("Gear scientific label 3");
        g.setScientificGear(true);
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 4");
        g.setLabel("Gear scientific label 4");
        g.setScientificGear(true);
        toExport.add(g);
        this.exportTemporaryGear(file, toExport);
    }

    protected ImportRequestResult<Gear, Integer> processImportFile(File file, List<Gear> existingEntities) {
        ImportRequestResult<Gear, Integer> requestResult = new ImportRequestResult<Gear, Integer>(existingEntities, TuttiEntities.newIdAstIntFunction(), Gears.GET_NAME);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            GearModel csvModel = new GearModel(this.getCsvSeparator());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (GearRow bean : importer) {
                    this.importGear(bean, requestResult);
                }
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.vessels.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        return requestResult;
    }

    private void importGear(GearRow bean, ImportRequestResult<Gear, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (id == null) {
            if (delete) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.cannotDeleteWithoutId.error", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.add.noName.error", (Object[])new Object[0]));
            }
            if (!requestResult.addExistingNaturalId(name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.existingName.error", (Object[])new Object[]{name}));
            }
            requestResult.addEntityToAdd(bean.toEntity());
        } else {
            Gear gear = requestResult.getExistingEntityById(id);
            if (gear == null) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.notExistingId.error", (Object[])new Object[]{id}));
            }
            if (delete) {
                if (this.persistenceService.isTemporaryGearUsed(id)) {
                    String gearRef = id + " : " + this.decoratorService.getDecoratorByType(Gear.class).toString((Object)gear);
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.used.error", (Object[])new Object[]{gearRef}));
                }
                requestResult.addIdToDelete(id);
                requestResult.removeExistingNaturalId(name);
            } else {
                if (StringUtils.isBlank((CharSequence)name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.noName.error", (Object[])new Object[]{id}));
                }
                if (!name.equals(gear.getName()) && !requestResult.addExistingNaturalId(name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.existingName.error", (Object[])new Object[]{name}));
                }
                requestResult.addEntityToUpdate(bean.toEntity());
            }
        }
    }

    protected void exportTemporaryGear(File file, List<Gear> toExport) throws IOException {
        GearModel csvModel = new GearModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Gear, GearRow>(){

            public GearRow apply(Gear gear) {
                return new GearRow(gear);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.gear.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

