/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.sumatra;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.service.export.sumatra.CatchRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.i18n.I18n;

public class CatchRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<CatchRow> {
    public CatchRowModel(char separator) {
        super(separator);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.year", (Object[])new Object[0]), "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.station", (Object[])new Object[0]), "stationNumber");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.multirigAggregation", (Object[])new Object[0]), "multirigAggregation");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.genuisSpecies", (Object[])new Object[0]), "species", TuttiCsvUtil.SPECIES_NAME_FORMATTER);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.surveySpecies", (Object[])new Object[0]), "species", TuttiCsvUtil.SPECIES_SURVEY_CODE_FORMATTER);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.sign", (Object[])new Object[0]), "sign");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.sortedWeight", (Object[])new Object[0]), "sortedWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.totalWeight", (Object[])new Object[0]), "totalWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.averageWeight", (Object[])new Object[0]), "averageWeight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.averageSize", (Object[])new Object[0]), "averageSize", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.number", (Object[])new Object[0]), "number", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.moule", (Object[])new Object[0]), "moule", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.startLatitude", (Object[])new Object[0]), "gearShootingStartLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.startLongitude", (Object[])new Object[0]), "gearShootingStartLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.endLatitude", (Object[])new Object[0]), "gearShootingEndLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.endLongitude", (Object[])new Object[0]), "gearShootingEndLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.startDate", (Object[])new Object[0]), "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatra.header.endDate", (Object[])new Object[0]), "gearShootingEndDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
    }

    public CatchRow newEmptyInstance() {
        return new CatchRow();
    }

    public CatchRow newRow(FishingOperation operation, ExportBatchEntry entry) {
        CatchRow row = this.newEmptyInstance();
        row.setFishingOperation(operation);
        row.setSpecies(entry.getBatch().getSpecies());
        row.setSortedWeight(Float.valueOf(entry.getSortedWeight()));
        float totalWeight = entry.getTotalWeight();
        int number = entry.getTotalNumber();
        row.setNumber(number);
        row.setTotalWeight(Float.valueOf(totalWeight));
        row.setAverageSize(entry.getAverageFrequency());
        row.setAverageWeight(number == 0 ? null : Float.valueOf(totalWeight / (float)number));
        row.setMoule(totalWeight == 0.0f ? null : Float.valueOf((float)number / totalWeight));
        return row;
    }
}

