/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.pupitri.Directions;
import fr.ifremer.tutti.service.pupitri.Signs;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class CarrouselRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_FILE_ORIGIN = "fileOrigin";
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_TIME = "time";
    public static final String PROPERTY_BALANCE_ID = "balanceId";
    public static final String PROPERTY_TO_CONFIRM = "toConfirm";
    public static final String PROPERTY_OPERATION_CODE = "operationCode";
    public static final String PROPERTY_RIG_NUMBER = "rigNumber";
    public static final String PROPERTY_BOX_TYPE = "boxType";
    public static final String PROPERTY_SPECIES_ID = "speciesId";
    public static final String PROPERTY_SIGN = "sign";
    public static final String PROPERTY_DIRECTION = "direction";
    public static final String PROPERTY_WEIGHT = "weight";
    protected String operationCode;
    protected Date date;
    protected String speciesId;
    protected Signs sign;
    protected Directions direction;
    protected Float weight;

    public boolean acceptOperation(FishingOperation operation) {
        return this.operationCode.equals(operation.getStationNumber()) && DateUtils.isSameDay((Date)this.date, (Date)operation.getGearShootingStartDate());
    }

    public String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(String speciesId) {
        this.speciesId = speciesId;
    }

    public Signs getSign() {
        return this.sign;
    }

    public void setSign(Signs sign) {
        if (Signs.UNSORTED.equals((Object)sign)) {
            sign = Signs.DEFAULT;
        }
        this.sign = sign;
    }

    public Directions getDirection() {
        return this.direction;
    }

    public void setDirection(Directions direction) {
        this.direction = direction;
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        this.weight = weight;
    }

    public boolean isSorted() {
        boolean sorted = Directions.VAT == this.direction;
        return sorted;
    }
}

