/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.sample.SampleDao;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Resource;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="samplePersistenceHelper")
public class SamplePersistenceHelper
extends AbstractPersistenceService {
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;
    @Resource(name="sampleDao")
    protected SampleDao sampleDao;

    public Sample create(Sample sample) {
        this.synchronizationStatusHelper.setDirty(sample);
        return this.sampleDao.create(sample);
    }

    public void update(Sample sample) {
        this.synchronizationStatusHelper.setDirty(sample);
        this.sampleDao.update(sample);
    }

    public Sample load(Integer id) {
        Sample sample = this.sampleDao.load(id);
        if (sample == null) {
            throw new DataRetrievalFailureException("Could not retrieve sample id=" + id);
        }
        return sample;
    }

    public void deleteSample(Integer sampleId) {
        Sample sample = this.load(sampleId);
        this.synchronizationStatusHelper.setDirty(sample);
        sample.getSampleMeasurements().clear();
        this.sampleDao.remove(sample);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.SAMPLE, sampleId);
    }

    public void setSampleMeasurements(Sample target, CaracteristicMap caracteristics) {
        HashSet notChangedSampleMeasurements = Sets.newHashSet();
        if (target.getSampleMeasurements() != null) {
            notChangedSampleMeasurements.addAll(target.getSampleMeasurements());
        }
        for (Caracteristic caracteristic : caracteristics.keySet()) {
            SampleMeasurement vum = this.setSampleMeasurement(target, caracteristic, (Serializable)caracteristics.get(caracteristic));
            notChangedSampleMeasurements.remove(vum);
        }
        if (target.getSampleMeasurements() != null && notChangedSampleMeasurements.size() > 0) {
            target.getSampleMeasurements().removeAll(notChangedSampleMeasurements);
        }
    }

    public void fillSampleMeasurements(CaracteristicMap result, Integer sampleId) {
        Iterator<Object[]> list = this.queryList("sampleMeasurements", "sampleId", IntegerType.INSTANCE, sampleId);
        while (list.hasNext()) {
            int colIndex = 0;
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[colIndex++];
            Float numericalValue = (Float)source[colIndex++];
            String alphanumericalValue = (String)source[colIndex++];
            Integer qualitativeValueId = (Integer)source[colIndex];
            Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    value = numericalValue;
                    break;
                }
                case QUALITATIVE: {
                    value = CaracteristicQualitativeValues.getQualitativeValue(caracteristic, qualitativeValueId);
                    break;
                }
                case TEXT: {
                    value = alphanumericalValue;
                }
            }
            result.put(caracteristic, value);
        }
    }

    protected SampleMeasurement setSampleMeasurement(Sample sample, Caracteristic caracteristic, Serializable value) {
        Integer pmfmId = caracteristic.getIdAsInt();
        SampleMeasurement result = null;
        if (sample.getSampleMeasurements() != null) {
            for (SampleMeasurement vum : sample.getSampleMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                result = vum;
                break;
            }
        }
        if (result == null) {
            result = SampleMeasurement.Factory.newInstance();
            result.setSample(sample);
            if (sample.getSampleMeasurements() == null) {
                sample.setSampleMeasurements((Collection)Sets.newHashSet((Object[])new SampleMeasurement[]{result}));
            } else {
                sample.getSampleMeasurements().add(result);
            }
            result.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            result.setDepartment(sample.getRecorderDepartment());
            result.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        this.measurementPersistenceHelper.setMeasurement((Measurement)result, caracteristic, value);
        return result;
    }
}

