/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.AccidentalCatchExportRow;
import fr.ifremer.tutti.service.export.generic.IndividualObservationExportRow;
import fr.ifremer.tutti.service.export.generic.SpeciesExportRow;
import fr.ifremer.tutti.service.export.generic.TuttiExportService;
import java.util.List;
import org.nuiton.csv.ValueFormatter;

public class SpeciesExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<SpeciesExportRow> {
    public SpeciesExportModel(char separator) {
        super(separator);
        this.newColumnForExport("Id", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("Code_Rubin", "species.refTaxCode");
        this.newColumnForExport("Nom Scientifique", "species.name");
        this.newColumnForExport("Code campagne", "species.surveyCode");
    }

    public void prepareBatchRows(TuttiExportService.ExportContext exportContext, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch) {
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            exportContext.addSpecies(speciesBatch.getSpecies());
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            exportContext.addSpecies(benthosBatch.getSpecies());
        }
    }

    public void prepareIndividualRows(TuttiExportService.ExportContext exportContext, List<IndividualObservationExportRow> rows) {
        for (IndividualObservationExportRow row : rows) {
            exportContext.addSpecies(row.getSpecies());
        }
    }

    public void prepareAccidentalRows(TuttiExportService.ExportContext exportContext, List<AccidentalCatchExportRow> rows) {
        for (AccidentalCatchExportRow row : rows) {
            exportContext.addSpecies(row.getSpecies());
        }
    }
}

