package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id: AttachmentModelAware.java 838 2013-04-20 14:33:56Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/attachment/AttachmentModelAware.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * To place on model wich supports attachments.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public interface AttachmentModelAware extends Serializable {

    String PROPERTY_ATTACHMENT = "attachment";

    String PROPERTY_OBJECT_ID = "objectId";

    AttachementObjectTypeEnum getObjectType();

    Integer getObjectId();

    List<Attachment> getAttachment();

    void addAllAttachment(Collection<Attachment> attachments);

    void addAttachment(Attachment attachment);

    void removeAllAttachment(Collection<Attachment> attachments);

    void removeAttachment(Attachment attachment);

}
