/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.bean;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import liquibase.util.csv.opencsv.CSVReader;
import liquibase.util.csv.opencsv.bean.MappingStrategy;

public class CsvToBean {
    public List parse(MappingStrategy mapper, Reader reader) {
        try {
            String[] line;
            CSVReader csv = new CSVReader(reader);
            mapper.captureHeader(csv);
            ArrayList<Object> list = new ArrayList<Object>();
            while ((line = csv.readNext()) != null) {
                Object obj = this.processLine(mapper, line);
                list.add(obj);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV!", e);
        }
    }

    protected Object processLine(MappingStrategy mapper, String[] line) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        Object bean = mapper.createBean();
        int col = 0;
        while (col < line.length) {
            String value = line[col];
            PropertyDescriptor prop = mapper.findDescriptor(col);
            if (prop != null) {
                Object obj = this.convertValue(value, prop);
                prop.getWriteMethod().invoke(bean, obj);
            }
            ++col;
        }
        return bean;
    }

    protected Object convertValue(String value, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor editor = this.getPropertyEditor(prop);
        Object obj = value;
        if (editor != null) {
            editor.setAsText(value);
            obj = editor.getValue();
        }
        return obj;
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (cls != null) {
            return (PropertyEditor)cls.newInstance();
        }
        return PropertyEditorManager.findEditor(desc.getPropertyType());
    }
}

