/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchs;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.TuttiCatchBatchValidator;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="batchPersistenceHelper")
public class BatchPersistenceHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(BatchPersistenceHelper.class);
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchPersistenceService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="sortingBatchDao")
    protected SortingBatchDao sortingBatchDao;
    @Resource(name="fishingOperationDao")
    protected FishingOperationDao fishingOperationDao;
    @Resource(name="scientificCruiseCatchBatchValidator")
    protected TuttiCatchBatchValidator catchBatchValidator;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public void init() {
        super.init();
        this.catchBatchDao.registerCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
    }

    @Override
    public void close() {
        this.catchBatchDao.unregisterCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
        super.close();
    }

    public fr.ifremer.tutti.persistence.entities.data.CatchBatch createCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean, CatchBatch catchBatch) {
        catchBatch = this.catchBatchDao.create(catchBatch);
        bean.setId(catchBatch.getId());
        return bean;
    }

    public void validateSpecies(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> species) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateSpecies(sampleCategoryModel, species);
        ArrayList errorsStr = Lists.newArrayList();
        for (CatchBatchValidationError error : errors) {
            if (error.getGravity() != 2) continue;
            errorsStr.add(error.getMessage());
        }
        if (!errorsStr.isEmpty()) {
            String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
            throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
        }
    }

    public void validateBenthos(SampleCategoryModel sampleCategoryModel, BatchContainer<BenthosBatch> benthos) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateBenthos(sampleCategoryModel, benthos);
        if (CollectionUtils.isNotEmpty(errors)) {
            ArrayList errorsStr = Lists.newArrayList();
            for (CatchBatchValidationError error : errors) {
                if (error.getGravity() != 2) continue;
                errorsStr.add(error.getMessage());
            }
            if (!errorsStr.isEmpty()) {
                String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
                throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
            }
        }
    }

    public void deleteCatchBatch(String fishingOperationId, Integer catchBatchId) {
        this.accidentalBatchService.deleteAccidentalBatchForFishingOperation(fishingOperationId);
        this.getCurrentSession().flush();
        this.individualObservationBatchPersistenceService.deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
        this.getCurrentSession().flush();
        FishingOperation fishingOperation = this.fishingOperationDao.load(Integer.valueOf(fishingOperationId));
        this.synchronizationStatusHelper.setDirty(fishingOperation.getFishingTrip());
        List ids = this.catchBatchDao.getAllChildrenIds(catchBatchId);
        this.catchBatchDao.remove(catchBatchId);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.CATCH_BATCH, catchBatchId);
        this.getCurrentSession().flush();
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public <D extends TuttiEntity> D createSortingBatch(D bean, CatchBatch catchBatch, SortingBatch batch) {
        this.synchronizationStatusHelper.setDirty(catchBatch);
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        return bean;
    }

    public void removeWithChildren(Integer batchId) {
        List ids = this.catchBatchDao.getAllChildrenIds(batchId);
        ids.add(batchId);
        this.catchBatchDao.removeWithChildren(batchId);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public void removeWithChildren(Integer batchId, CatchBatch parentCatchBatch) {
        List ids = this.catchBatchDao.getAllChildrenIds(batchId);
        ids.add(batchId);
        this.catchBatchDao.removeWithChildren(batchId, parentCatchBatch);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public void updateSortingBatch(List<SortingBatch> sortingBatchs, CatchBatch parentCatchBatch) {
        this.catchBatchDao.updateSortingBatch(sortingBatchs, parentCatchBatch);
    }

    public SortingBatch loadSortingBatch(Integer sortingBatchId, CatchBatch parentCatchBatch) {
        return this.catchBatchDao.loadSortingBatch(sortingBatchId, parentCatchBatch);
    }

    public void update(CatchBatch catchBatch) {
        this.catchBatchDao.update(catchBatch);
    }

    public SortingBatch getSortingBatchById(CatchBatch catchBatch, Integer sortingBatchId) {
        return this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
    }

    public void updateSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
        this.synchronizationStatusHelper.setDirty(parentCatchBatch);
        this.catchBatchDao.updateSortingBatch(sortingBatch, parentCatchBatch);
    }

    public List<SortingBatch> getFrequencyChilds(SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(sampleCategoryModel, child)) continue;
            result.add(child);
        }
        return result;
    }

    public List<SortingBatch> getFrequencies(String batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer sortingBatchId = Integer.valueOf(batchId);
        CatchBatch catchBatch = this.getRootCatchBatchByBatchId(sortingBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        List<SortingBatch> frequencyChilds = this.getFrequencyChilds(sortingBatch);
        return frequencyChilds;
    }

    public CatchBatch getRootCatchBatchByFishingOperationId(String fishingOperationId, boolean validate) {
        CatchBatch result;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        if (validate) {
            try {
                result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue(), true, false);
            }
            catch (CatchBatchValidationException e) {
                throw new InvalidBatchModelException("L'arbre d'\u00e9chantillonage n'est pas compatible avec celui de Tutti.", e);
            }
        } else {
            result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue());
        }
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public boolean isCatchBatchExistsForFishingOperation(Integer fishingOperationId) {
        return this.catchBatchDao.isCatchBatchExistsForFishingOperation(fishingOperationId);
    }

    public Integer getCatchBatchIdByFishingOperationId(Integer fishingOperationId) throws DataRetrievalFailureException {
        return this.catchBatchDao.getIdByFishingOperationId(fishingOperationId);
    }

    public CatchBatch getRootCatchBatchByBatchId(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(batchId);
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue());
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public void setSpeciesBatchParents(Integer sampleCategoryId, Serializable sampleCategoryValue, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)catchBatch);
        target.setRootBatch(catchBatch);
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            if (!sampleCategoryId.equals(PmfmId.SORTED_UNSORTED.getValue())) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", sampleCategoryId, PmfmId.SORTED_UNSORTED.getValue()));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (QualitativeValueId.SORTED_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.batchTreeHelper.getSpeciesVracAliveItemizedRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch vracSpeciesBatch;
                    SortingBatch vracBatch = this.batchTreeHelper.getVracBatch(catchBatch);
                    if (vracBatch == null) {
                        vracBatch = this.batchTreeHelper.getOrCreateVracBatch(catchBatch, null, null);
                    }
                    if ((vracSpeciesBatch = this.batchTreeHelper.getSpeciesVracRootBatch(vracBatch)) == null) {
                        vracSpeciesBatch = this.batchTreeHelper.getOrCreateSpeciesVracRootBatch(catchBatch, vracBatch, null);
                    }
                    parentBatch = this.batchTreeHelper.getOrCreateSpeciesVracAliveItemizedRootBatch(catchBatch, vracSpeciesBatch);
                }
            } else if (QualitativeValueId.SORTED_HORS_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.batchTreeHelper.getSpeciesHorsVracRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch horsVracBatch = this.batchTreeHelper.getOrCreateHorsVracBatch(catchBatch);
                    parentBatch = this.batchTreeHelper.getOrCreateSpeciesHorsVracRootBatch(catchBatch, horsVracBatch);
                }
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hor Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        Preconditions.checkNotNull((Object)parentBatch);
        target.setParentBatch((Batch)parentBatch);
    }

    public void setBenthosBatchParents(Integer sampleCategoryType, Serializable sampleCategoryValue, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)catchBatch);
        target.setRootBatch(catchBatch);
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            if (!sampleCategoryType.equals(PmfmId.SORTED_UNSORTED.getValue())) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", sampleCategoryType, PmfmId.SORTED_UNSORTED.getValue()));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (QualitativeValueId.SORTED_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.batchTreeHelper.getBenthosVracAliveItemizedRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch vracBenthosBatch;
                    SortingBatch vracBatch = this.batchTreeHelper.getVracBatch(catchBatch);
                    if (vracBatch == null) {
                        vracBatch = this.batchTreeHelper.getOrCreateVracBatch(catchBatch, null, null);
                    }
                    if ((vracBenthosBatch = this.batchTreeHelper.getBenthosVracRootBatch(vracBatch)) == null) {
                        vracBenthosBatch = this.batchTreeHelper.getOrCreateBenthosVracRootBatch(catchBatch, vracBatch, null);
                    }
                    parentBatch = this.batchTreeHelper.getOrCreateBenthosVracAliveItemizedRootBatch(catchBatch, vracBenthosBatch);
                }
            } else if (QualitativeValueId.SORTED_HORS_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.batchTreeHelper.getBenthosHorsVracRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch horsVracBatch = this.batchTreeHelper.getOrCreateHorsVracBatch(catchBatch);
                    parentBatch = this.batchTreeHelper.getOrCreateBenthosHorsVracRootBatch(catchBatch, horsVracBatch);
                }
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hors Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        Preconditions.checkNotNull((Object)parentBatch);
        target.setParentBatch((Batch)parentBatch);
    }

    public void setMarineLitterBatchParents(SortingBatch target, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)target);
        SortingBatch parentBatch = this.batchTreeHelper.getMarineLitterRootBatch(catchBatch);
        if (parentBatch == null) {
            SortingBatch horsVracBatch = this.batchTreeHelper.getOrCreateHorsVracBatch(catchBatch);
            parentBatch = this.batchTreeHelper.getOrCreateMarineLitterRootBatch(catchBatch, horsVracBatch, null);
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }

    public void beanToEntity(String parentBatchId, SpeciesAbleBatch source, SortingBatch target) {
        Integer pmfmId;
        if (target.getRankOrder() == null) {
            Number r;
            int maxRankOrder;
            short rankOrder = 1;
            if (source.getParentBatch() != null && CollectionUtils.isNotEmpty(source.getParentBatch().getChildBatchs())) {
                maxRankOrder = 0;
                for (SpeciesAbleBatch speciesAbleBatch : source.getParentBatch().getChildBatchs()) {
                    r = speciesAbleBatch.getRankOrder();
                    if (r == null || (Integer)r <= maxRankOrder) continue;
                    maxRankOrder = (Integer)r;
                }
                rankOrder = (short)(rankOrder + (short)maxRankOrder);
            } else if (target.getParentBatch() != null && CollectionUtils.isNotEmpty((Collection)target.getParentBatch().getChildBatchs())) {
                maxRankOrder = 0;
                for (Batch batch : target.getParentBatch().getChildBatchs()) {
                    r = batch.getRankOrder();
                    if (r == null || (Short)r <= maxRankOrder) continue;
                    maxRankOrder = ((Short)r).shortValue();
                }
                rankOrder = (short)(rankOrder + maxRankOrder);
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        target.setIndividualCount(source.getNumber());
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        ReferenceTaxon referenceTaxon = source.getSpecies() == null || parentBatchId != null ? null : (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
        target.setReferenceTaxon(referenceTaxon);
        String qualityFlag = source.isSpeciesToConfirm() ? QualityFlagCode.DOUBTFUL.getValue() : QualityFlagCode.NOTQUALIFIED.getValue();
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)qualityFlag)));
        Float weight = source.getWeight();
        Float sampleCategoryWeight = source.getSampleCategoryWeight();
        this.batchTreeHelper.setWeightAndSampleRatio(target, weight, sampleCategoryWeight);
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet hashSet = Sets.newHashSet();
        if (sortingMeasurements != null) {
            hashSet.addAll(sortingMeasurements);
        }
        if (source.getSampleCategoryId() != null && source.getSampleCategoryValue() != null && !(pmfmId = source.getSampleCategoryId()).equals(PmfmId.SORTED_UNSORTED.getValue())) {
            SortingMeasurement sortingMeasurement = this.measurementPersistenceHelper.setSortingMeasurement(target, pmfmId, source.getSampleCategoryValue());
            hashSet.remove(sortingMeasurement);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(hashSet);
        }
    }

    public void beanToEntity(SpeciesAbleBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        target.setIndividualCount(source.getNumber());
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        this.batchTreeHelper.setWeightAndSampleRatio(target, source.getWeight(), null);
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = source.getLengthStepCaracteristic().getIdAsInt();
            SortingMeasurement sortingMeasurement = this.measurementPersistenceHelper.setSortingMeasurement(target, pmfmId, source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    public <B extends SpeciesAbleBatch> B entityToBean(SampleCategoryModel sampleCategoryModel, SortingBatch source, B target) {
        QualityFlag qualityFlag;
        SortingBatch childBatch;
        boolean isFrequency;
        boolean isFrequency2;
        Preconditions.checkNotNull((Object)target.getSpecies());
        target.setId(source.getId().toString());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.measurementPersistenceHelper.getInheritedSortingMeasurement(source);
        }
        if (sm != null && !(isFrequency2 = this.isFrequencyBatch(sampleCategoryModel, source))) {
            Integer qualitativeId = null;
            if (sm.getQualitativeValue() != null) {
                qualitativeId = sm.getQualitativeValue().getId();
            }
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), qualitativeId);
        }
        if (target.getSampleCategoryId() != null) {
            ArrayList targetChilds = Lists.newArrayList();
            for (Batch batch : source.getChildBatchs()) {
                SortingBatch sourceChild = (SortingBatch)batch;
                B targetChild = SpeciesAbleBatchs.newInstance(target);
                targetChild.setSpecies(target.getSpecies());
                this.entityToBean(sampleCategoryModel, sourceChild, targetChild);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded CatchBatch (Vrac|Hors Vrac) > Species > " + targetChild.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
                }
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                SpeciesAbleBatchs.setParentBatch(target, targetChild);
            }
            SpeciesAbleBatchs.setChildBatchs(target, targetChilds);
        }
        if (CollectionUtils.isNotEmpty((Collection)source.getChildBatchs()) && target.getWeight() != null && !(isFrequency = this.isFrequencyBatch(sampleCategoryModel, childBatch = (SortingBatch)Iterables.get((Iterable)source.getChildBatchs(), (int)0)))) {
            target.setWeight(null);
        }
        target.setSpeciesToConfirm((qualityFlag = source.getQualityFlag()) != null && QualityFlagCode.DOUBTFUL.getValue().equals(qualityFlag.getCode()));
        return target;
    }

    public Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = cqValue.getIdAsInt();
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }

    public void deleteBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        CatchBatch catchBatch = this.getRootCatchBatchByBatchId(batchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        this.removeWithChildren(batchId);
    }

    public void deleteSpeciesSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer speciesBatchId = Integer.valueOf(id);
        CatchBatch catchBatch = this.getRootCatchBatchByBatchId(speciesBatchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch sortingBatch = this.getSortingBatchById(catchBatch, speciesBatchId);
        Collection childBatchs = sortingBatch.getChildBatchs();
        if (CollectionUtils.isNotEmpty((Collection)childBatchs)) {
            for (Batch childBatch : childBatchs) {
                Integer childBatchId = childBatch.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete child [" + childBatchId + "] of species batch: " + id));
                }
                this.removeWithChildren(childBatchId);
            }
        }
    }

    public void changeBatchSpecies(String id, Species species) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        Integer batchId = Integer.valueOf(id);
        CatchBatch catchBatch = this.getRootCatchBatchByBatchId(batchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        this.catchBatchDao.setSortingBatchReferenceTaxon(id, species.getReferenceTaxonId());
    }

    public <S extends SpeciesAbleBatch> void setSampleCategoryQualitative(S target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(BatchTreeHelper.SORTING_TYPE_ID)) {
            return;
        }
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        boolean isSamplingCategory = sampleCategoryModel.containsCategoryId(pmfmId);
        Preconditions.checkNotNull((Object)isSamplingCategory, (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryId(pmfmId);
        Serializable categoryValue = this.getSampleCategoryQualitative(pmfmId, numericalvalue, alphanumericalValue, qualitativeValueId);
        target.setSampleCategoryValue(categoryValue);
    }

    public <F extends SpeciesAbleBatchFrequency & TuttiEntity> void entityToBatchFrequency(SortingBatch source, F target) {
        ((TuttiEntity)target).setId(source.getId());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        Preconditions.checkState((source.getSortingMeasurements().size() == 1 ? 1 : 0) != 0, (Object)("SortingBatch [" + source.getId() + "] need exactly one sortingMeasurement (to store the length step category), but had " + source.getSortingMeasurements().size()));
        SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        Preconditions.checkNotNull((Object)sm.getPmfm(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a null pmfm"));
        Preconditions.checkNotNull((Object)sm.getPmfm().getId(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a pmfm with null id"));
        Caracteristic lengthStepCaracteristic = this.caracteristicService.getCaracteristic(sm.getPmfm().getId());
        target.setLengthStepCaracteristic(lengthStepCaracteristic);
        target.setLengthStep(sm.getNumericalValue());
    }

    public Serializable getSampleCategoryQualitative(Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (numericalvalue != null) {
            return numericalvalue;
        }
        if (alphanumericalValue != null) {
            return alphanumericalValue;
        }
        Caracteristic caracteristic = this.caracteristicService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return null;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        return value;
    }

    public boolean isFrequencyBatch(SampleCategoryModel sampleCategoryModel, SortingBatch sortingBatch) {
        boolean result = false;
        if (sortingBatch.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            Pmfm pmfm = sm.getPmfm();
            result = sortingBatch.getIndividualCount() != null && !sampleCategoryModel.containsCategoryId(pmfm.getId());
        }
        return result;
    }
}

