/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchs;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.data.TuttiBatchEntity;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import java.util.List;

public class SpeciesAbleBatchs {
    public static Predicate<SpeciesAbleBatch> newSpeciesAbleBatchCategoryPredicate(Integer cateogryId, Integer value) {
        return new SpeciesAbleBatchCategoryPredicate(cateogryId, value);
    }

    public static <B extends SpeciesAbleBatch> B newInstance(B parent) {
        TuttiBatchEntity targetChild = parent instanceof SpeciesBatch ? SpeciesBatchs.newSpeciesBatch() : BenthosBatchs.newBenthosBatch();
        return (B)targetChild;
    }

    public static <B extends SpeciesAbleBatch> B createNewChild(B parent) {
        B child = SpeciesAbleBatchs.newInstance(parent);
        child.setFishingOperation(parent.getFishingOperation());
        child.setSpecies(parent.getSpecies());
        SpeciesAbleBatchs.setParentBatch(parent, child);
        SpeciesAbleBatchs.addChildBatch(parent, child);
        return child;
    }

    public static <B extends SpeciesAbleBatch> void setChildBatchs(B parent, List<B> childs) {
        if (parent instanceof SpeciesBatch) {
            ((SpeciesBatch)parent).setChildBatchs(childs);
        } else {
            ((BenthosBatch)parent).setChildBatchs(childs);
        }
    }

    public static <B extends SpeciesAbleBatch> List<B> getChildBatchs(B batch) {
        return batch.getChildBatchs();
    }

    public static <B extends SpeciesAbleBatch> void setParentBatch(B parent, B child) {
        if (parent instanceof SpeciesBatch) {
            ((SpeciesBatch)child).setParentBatch((SpeciesBatch)parent);
        } else {
            ((BenthosBatch)child).setParentBatch((BenthosBatch)parent);
        }
    }

    public static <B extends SpeciesAbleBatch> void addChildBatch(B parent, B child) {
        if (child instanceof SpeciesBatch) {
            ((SpeciesBatch)parent).addChildBatchs((SpeciesBatch)child);
        } else {
            ((BenthosBatch)parent).addChildBatchs((BenthosBatch)child);
        }
    }

    public static class SpeciesAbleBatchCategoryPredicate
    implements Predicate<SpeciesAbleBatch> {
        private final Integer id;
        private final Integer qualitativeValue;

        public SpeciesAbleBatchCategoryPredicate(Integer id, Integer qualitativeValue) {
            this.id = id;
            this.qualitativeValue = qualitativeValue;
        }

        public boolean apply(SpeciesAbleBatch input) {
            return this.id.equals(input.getSampleCategoryId()) && input.getSampleCategoryValue() instanceof CaracteristicQualitativeValue && this.qualitativeValue.equals(((CaracteristicQualitativeValue)input.getSampleCategoryValue()).getIdAsInt());
        }
    }
}

