/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;

class ClientIterator
implements Iterator {
    protected Iterator iter;
    protected Module module;

    public ClientIterator(DesignElementHandle elementHandle) {
        assert (elementHandle != null);
        this.module = elementHandle.getModule();
        assert (this.module != null);
        if (elementHandle.getElement() instanceof IReferencableElement) {
            IReferencableElement element = (IReferencableElement)((Object)elementHandle.getElement());
            this.iter = element.getClientList().iterator();
        } else {
            this.iter = null;
        }
    }

    @Override
    public void remove() {
        throw new IllegalOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.iter != null) {
            return this.iter.hasNext();
        }
        return false;
    }

    public Object next() {
        if (this.iter != null) {
            BackRef client = (BackRef)this.iter.next();
            return client.getElement().getHandle(this.module);
        }
        return null;
    }
}

