/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class GenericformatImportPersistenceHelper {
    private final GenericFormatContextSupport importContext;
    private final PersistenceService persistenceService;
    private final ReferentialTemporaryGearService referentialTemporaryGearService;
    private final ReferentialTemporaryPersonService referentialTemporaryPersonService;
    private final ReferentialTemporarySpeciesService referentialTemporarySpeciesService;
    private final ReferentialTemporaryVesselService referentialTemporaryVesselService;
    private final ProtocolImportExportService protocolImportExportService;

    public GenericformatImportPersistenceHelper(TuttiServiceContext context, GenericFormatContextSupport importContext) {
        this.importContext = importContext;
        this.persistenceService = context.getService(PersistenceService.class);
        this.referentialTemporaryGearService = context.getService(ReferentialTemporaryGearService.class);
        this.referentialTemporaryPersonService = context.getService(ReferentialTemporaryPersonService.class);
        this.referentialTemporarySpeciesService = context.getService(ReferentialTemporarySpeciesService.class);
        this.referentialTemporaryVesselService = context.getService(ReferentialTemporaryVesselService.class);
        this.protocolImportExportService = context.getService(ProtocolImportExportService.class);
    }

    public Set<FishingOperation> getFishingOperations(String cruiseId) {
        List<FishingOperation> allFishingOperation = this.persistenceService.getAllFishingOperation(cruiseId);
        LinkedHashSet existingFishingOperations = Sets.newLinkedHashSet(allFishingOperation);
        return existingFishingOperations;
    }

    public void deleteAllAttachments(ObjectTypeCode objectTypeCode, Integer objectId) {
        this.persistenceService.deleteAllAttachment(objectTypeCode, objectId);
    }

    public void persistAttachments(Integer objectId, Collection<AttachmentRow> attachmentRows) {
        if (this.importContext.getImportRequest().isImportAttachments() && CollectionUtils.isNotEmpty(attachmentRows)) {
            for (AttachmentRow attachmentRow : attachmentRows) {
                Attachment attachment = attachmentRow.toAttachment(objectId);
                File attachmentFile = this.importContext.getImportRequest().getArchive().extractAttachment(attachment.getPath());
                this.persistenceService.createAttachment(attachment, attachmentFile);
            }
        }
    }

    public Cruise createCruise(Cruise cruise) {
        return this.persistenceService.createCruise(cruise);
    }

    public Cruise saveCruise(Cruise cruise) {
        return this.persistenceService.saveCruise(cruise, false, false);
    }

    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.persistenceService.saveGearCaracteristics(gear, cruise);
    }

    public FishingOperation createFishingOperation(FishingOperation fishingOperation) {
        FishingOperation saveFishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        return saveFishingOperation;
    }

    public FishingOperation saveFishingOperation(FishingOperation fishingOperation) {
        FishingOperation saveFishingOperation = this.persistenceService.saveFishingOperation(fishingOperation);
        return saveFishingOperation;
    }

    public CatchBatch getExistingCatchBatch(String operationId) {
        boolean withCatchBatch = this.isWithCatchBatch(operationId);
        CatchBatch catchBatch = withCatchBatch ? this.persistenceService.getCatchBatchFromFishingOperation(operationId) : null;
        return catchBatch;
    }

    public boolean isWithCatchBatch(String operationId) {
        return this.persistenceService.isFishingOperationWithCatchBatch(operationId);
    }

    public CatchBatch createCatchBatch(CatchBatch catchBatch) {
        return this.persistenceService.createCatchBatch(catchBatch);
    }

    public CatchBatch saveCatchBatch(CatchBatch catchBatch) {
        return this.persistenceService.saveCatchBatch(catchBatch);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch batch, String parentId) {
        return this.persistenceService.createSpeciesBatch(batch, parentId);
    }

    public void saveSpeciesBatchFrequency(String batchId, List<SpeciesBatchFrequency> frequencies) {
        this.persistenceService.saveSpeciesBatchFrequency(batchId, frequencies);
    }

    public void deleteSpeciesBatchForFishingOperation(String fishingOperationId) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, false);
        for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
            this.persistenceService.deleteSpeciesBatch(batch.getId());
        }
    }

    public BenthosBatch createBenthosBatch(BenthosBatch batch, String parentId) {
        return this.persistenceService.createBenthosBatch(batch, parentId);
    }

    public void saveBenthosBatchFrequency(String batchId, List<BenthosBatchFrequency> frequencies) {
        this.persistenceService.saveBenthosBatchFrequency(batchId, frequencies);
    }

    public void deleteBenthosBatchForFishingOperation(String fishingOperationId) {
        BatchContainer<BenthosBatch> rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, false);
        for (BenthosBatch batch : rootBenthosBatch.getChildren()) {
            this.persistenceService.deleteBenthosBatch(batch.getId());
        }
    }

    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch marineLitterBatch) {
        return this.persistenceService.createMarineLitterBatch(marineLitterBatch);
    }

    public void deleteMarineLitterForFishingOperation(String fishingOperationId) {
        BatchContainer<MarineLitterBatch> rootMarineLitters = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        for (MarineLitterBatch batch : rootMarineLitters.getChildren()) {
            this.persistenceService.deleteMarineLitterBatch(batch.getId());
        }
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch accidentalBatch) {
        return this.persistenceService.createAccidentalBatch(accidentalBatch);
    }

    public void deleteAccidentalBatchForFishingOperation(String fishingOperationId) {
        this.persistenceService.deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch individualObservationBatch) {
        return this.persistenceService.createIndividualObservationBatch(individualObservationBatch);
    }

    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        this.persistenceService.deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
    }

    public void setSampleCategoryModel(SampleCategoryModel sampleCategoryModel) {
        this.persistenceService.setSampleCategoryModel(sampleCategoryModel);
    }

    public ReferentialImportRequest<Gear, Integer> createGearImportRequest() {
        return this.referentialTemporaryGearService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Gear> importGears(ReferentialImportRequest<Gear, Integer> referentialImportRequest) {
        return this.referentialTemporaryGearService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Person, Integer> createPersonImportRequest() {
        return this.referentialTemporaryPersonService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Person> importPersons(ReferentialImportRequest<Person, Integer> referentialImportRequest) {
        return this.referentialTemporaryPersonService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Vessel, String> createVesselsImportRequest() {
        return this.referentialTemporaryVesselService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Vessel> importVessels(ReferentialImportRequest<Vessel, String> referentialImportRequest) {
        return this.referentialTemporaryVesselService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Species, Integer> createSpeciesImportRequest() {
        return this.referentialTemporarySpeciesService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Species> importSpecies(ReferentialImportRequest<Species, Integer> referentialImportRequest) {
        return this.referentialTemporarySpeciesService.executeImportRequest(referentialImportRequest);
    }

    public TuttiProtocol importProtocol(File file) {
        return this.protocolImportExportService.importProtocol(file);
    }

    public List<Species> getAllReferentSpecies() {
        return this.persistenceService.getAllReferentSpecies();
    }

    public TuttiProtocol createProtocol(TuttiProtocol tuttiProtocol) {
        TuttiProtocol createdProtocol = this.persistenceService.createProtocol(tuttiProtocol);
        this.persistenceService.setProtocol(createdProtocol);
        return createdProtocol;
    }

    public String getProtocolFirstAvailableName(String protocolOriginalName) {
        return this.persistenceService.getFirstAvailableName(protocolOriginalName);
    }
}

