/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

public class GenericFormatImportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final GenericFormatImportConfiguration importConfiguration;
    private final GenericFormatArchive archive;
    private final char csvSeparator;
    private final SampleCategoryModel sampleCategoryModel;
    private final Set<Cruise> existingCruises;
    private final TuttiProtocol protocol;
    private final Program program;
    private final Date startingDate;
    private final ProgramDataModel existingData;

    public GenericFormatImportRequest(GenericFormatImportConfiguration importConfiguration, GenericFormatArchive archive, char csvSeparator, Program program, SampleCategoryModel sampleCategoryModel, Set<Cruise> cruises, ProgramDataModel existingData, TuttiProtocol protocol) {
        this.importConfiguration = importConfiguration;
        this.archive = archive;
        this.csvSeparator = csvSeparator;
        this.sampleCategoryModel = sampleCategoryModel;
        this.program = program;
        this.existingCruises = cruises;
        this.existingData = existingData;
        this.protocol = protocol;
        this.startingDate = new Date();
    }

    public GenericFormatArchive getArchive() {
        return this.archive;
    }

    public char getCsvSeparator() {
        return this.csvSeparator;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public TuttiProtocol getProtocol() {
        return this.protocol;
    }

    public Program getProgram() {
        return this.program;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public GenericFormatImportConfiguration getImportConfiguration() {
        return this.importConfiguration;
    }

    public CruiseDataModel getExistingCruiseData(Cruise importRowCruise) {
        String cruiseId = this.getExistingCruiseId(importRowCruise);
        CruiseDataModel result = null;
        if (cruiseId != null) {
            for (CruiseDataModel cruiseDataModel : this.existingData) {
                if (!cruiseId.equals(cruiseDataModel.getId())) continue;
                result = cruiseDataModel;
                break;
            }
        }
        return result;
    }

    public boolean isCleanWeights() {
        return this.importConfiguration.isCleanWeights();
    }

    public boolean isCheckWeights() {
        return this.importConfiguration.isCheckWeights();
    }

    public boolean isOverrideData() {
        return this.importConfiguration.isOverrideData();
    }

    public boolean isOverrideProtocol() {
        return this.importConfiguration.isOverrideProtocol();
    }

    public boolean isUpdateCruises() {
        return this.importConfiguration.isUpdateCruises();
    }

    public boolean isUpdateOperations() {
        return this.importConfiguration.isUpdateOperations();
    }

    public boolean isImportSpecies() {
        return this.importConfiguration.isImportSpecies();
    }

    public boolean isImportBenthos() {
        return this.importConfiguration.isImportBenthos();
    }

    public boolean isImportMarineLitter() {
        return this.importConfiguration.isImportMarineLitter();
    }

    public boolean isImportAccidentalCatch() {
        return this.importConfiguration.isImportAccidentalCatch();
    }

    public boolean isImportIndividualObservation() {
        return this.importConfiguration.isImportIndividualObservation();
    }

    public boolean isImportAttachments() {
        return this.importConfiguration.isImportAttachments();
    }

    public File getReportFile() {
        return this.importConfiguration.getReportFile();
    }

    protected String getExistingCruiseId(Cruise importRowCruise) {
        String result = null;
        for (Cruise cruise : this.existingCruises) {
            boolean equals = Cruises.equals((Cruise)importRowCruise, (Cruise)cruise);
            if (!equals) continue;
            result = cruise.getId();
            break;
        }
        return result;
    }

    public CruiseDataModel getSelectedCruise(Cruise importRowCruise) {
        CruiseDataModel result = null;
        ProgramDataModel dataToExport = this.importConfiguration.getDataToExport();
        for (CruiseDataModel selectedCruise : dataToExport) {
            boolean equals = Cruises.equalsNaturalId((Cruise)importRowCruise, (String)selectedCruise.getId());
            if (!equals) continue;
            result = selectedCruise;
            break;
        }
        return result;
    }
}

